<?php
namespace MASCOTCORECHARITAB\Shortcodes\TribeEvents;

use MASCOTCORECHARITAB\Shortcodes\Lib;

/**
 * class SC_Tribe_Single_Event
 * @package MASCOTCORECHARITAB\Shortcodes\TribeEvents;
 */
class SC_Tribe_Single_Event implements Lib\Mascot_Core_Charitab_Interface_Shortcodes {
	
	/**
	 * @var shortcode_base
	 */
	private $shortcode_base;

	/**
	 * construct
	 */
	public function __construct() {
		$this->shortcode_base = 'tm_tribe_single_event';
		add_action('init', array($this, 'MapShortCodeVC'), 998);
	}

	/**
	 * Returns shortcode_base for shortcode
	 */
	public function getShortCodeBase() {
		return $this->shortcode_base;
	}

	/**
	 * Maps shortcode to Visual Composer
	 */
	public function MapShortCodeVC() {
		$group_content_options = esc_html__( 'Content Options', 'mascot-core' );
		$group_button_options = esc_html__( 'Button Options', 'mascot-core' );


		if(function_exists('vc_map')) {
			$vc_map = array(
				'name'		=> esc_html__( 'Tribe Single Event', 'mascot-core' ),
				'base'		=>$this->shortcode_base,
				'category'	=> 'by TM',
				'description' => esc_html__( 'Single Event', 'mascot-core' ),
				'icon'		=> 'mascot-vc-icons vc-icon-event',
				'allowed_container_element' => 'vc_row',
				'params'	=>array(
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Custom CSS class", 'mascot-core' ),
						"param_name"	=> "custom_css_class",
						"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Display Type", 'mascot-core' ),
						"param_name"	=> "display_type",
						"description"	=> "",
						'value'			=> array(
							esc_html__( 'Current Theme Style', 'mascot-core' )	=> 'current-theme'
						),
						'save_always'   => true,
						'admin_label'   => true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Choose Event to Display", 'mascot-core' ),
						"param_name"	=> "id",
						'value'			=> mascot_core_charitab_get_post_list_array_by_post_type( 'tribe_events', true ),
						'admin_label'   => true,
					),



					//Content Options
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Thumbnail", 'mascot-core' ),
						"param_name"	=> "show_thumb",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Thumbnail Image Size", 'mascot-core' ),
						"param_name"	=> "feature_thumb_image_size",
						'description'   => '',
						'value'			=> mascot_core_charitab_get_available_image_sizes_for_vc(),
						'std'			=> 'post-thumbnail',
						'save_always'   => true,
						'dependency'	=> array('element' => 'show_thumb', 'value' => 'true'),
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Title", 'mascot-core' ),
						"param_name"	=> "show_title",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Excerpt", 'mascot-core' ),
						"param_name"	=> "show_excerpt",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Excerpt Length", 'mascot-core' ),
						"param_name"	=> "excerpt_length",
						"description"	=> esc_html__( 'Number of words to display. Example: 25. Default all.', 'mascot-core' ),
						'dependency'	=> array('element' => 'show_excerpt', 'value' => 'true'),
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Timer", 'mascot-core' ),
						"param_name"	=> "show_timer",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Meta", 'mascot-core' ),
						"param_name"	=> "show_meta",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'checkbox',
						"heading"		=> esc_html__( "Choose Meta", 'mascot-core' ),
						"param_name"	=> "meta_options",
						"description"	=> esc_html__( 'Enable/Disabling this option will show/hide each Post Meta.', 'mascot-core' ),
						'value'			=> array(
							esc_html__( 'Show Full Date & Time', 'mascot-core' )	=> 'show-full-date',
							esc_html__( 'Show Only Time', 'mascot-core' )			=> 'show-time',
							esc_html__( 'Show Venue', 'mascot-core' )				=> 'show-venue',
							esc_html__( 'Show Organizer', 'mascot-core' )			=> 'show-organizer',
						),
						'std'			=> 'show-time',
						'save_always'   => true,
						'dependency'	=> array('element' => 'show_meta', 'value' => 'true'),
						'group'			=> $group_content_options
					),





					
					//Button
					mascot_core_charitab_get_viewdetails_button_arraylist( 1, $group_button_options ),
					mascot_core_charitab_get_viewdetails_button_arraylist( 2, $group_button_options ),

					//button options
					mascot_core_charitab_get_button_arraylist( 1, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 2, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 3, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 4, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 5, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 6, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 7, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 8, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 9, $group_button_options ),

					mascot_core_charitab_vc_add_css_editor(),

				)
			);
			vc_map( $vc_map );

			//Modify vc_map from themes
			if( function_exists('mascot_core_charitab_sc_tribe_single_event_vc_map_modifier') ) {
				mascot_core_charitab_sc_tribe_single_event_vc_map_modifier( $this->shortcode_base );
			}
		}
	}

	/**
	 * Renders shortcodes HTML
	 */
	public function render( $attr, $content = null ) {

		//Render Shortcode from themes
		if( function_exists('mascot_core_charitab_sc_tribe_single_event_render') && class_exists( 'Tribe__Events__Main') && function_exists('vc_map') ) {
			return mascot_core_charitab_sc_tribe_single_event_render( $attr, $content );
		}
		
	}
}