<?php
namespace MASCOTCORECHARITAB\Shortcodes\TribeEvents;

use MASCOTCORECHARITAB\Shortcodes\Lib;

/**
 * class SC_Tribe_Events
 * @package MASCOTCORECHARITAB\Shortcodes\TribeEvents;
 */
class SC_Tribe_Events implements Lib\Mascot_Core_Charitab_Interface_Shortcodes {
	
	/**
	 * @var shortcode_base
	 */
	private $shortcode_base;

	/**
	 * construct
	 */
	public function __construct() {
		$this->shortcode_base = 'tm_tribe_events';
		add_action('init', array($this, 'MapShortCodeVC'), 998);
	}

	/**
	 * Returns shortcode_base for shortcode
	 */
	public function getShortCodeBase() {
		return $this->shortcode_base;
	}

	/**
	 * Maps shortcode to Visual Composer
	 */
	public function MapShortCodeVC() {
		$group_content_options = esc_html__( 'Content', 'mascot-core' );
		$group_carousel_options = esc_html__( 'Carousel', 'mascot-core' );
		$group_query_options = esc_html__( 'Query', 'mascot-core' );
		$group_button_options = esc_html__( 'Button', 'mascot-core' );
		$group_loadmore_button_options = esc_html__( 'Loadmore Button', 'mascot-core' );

		$group_list_vertical_options = esc_html__( 'List - Vertical' );
		$group_list_vertical_slide_options = esc_html__( 'List - Vertical Slide' );

		$categories_array = mascot_core_charitab_category_list_array_for_vc( 'tribe_events_cat' );
		$orderby_parameters_list1 = mascot_core_charitab_orderby_parameters_list();
		$orderby_parameters_list2 = array(
		);
		$orderby_parameters_list = array_merge( $orderby_parameters_list2, $orderby_parameters_list1 );


		if(function_exists('vc_map')) {
			$vc_map = array(
				'name'		=> esc_html__( 'Tribe Events', 'mascot-core' ),
				'base'		=>$this->shortcode_base,
				'category'	=> 'by TM',
				'description' => esc_html__( 'Events List/Grid/Carousel', 'mascot-core' ),
				'icon'		=> 'mascot-vc-icons vc-icon-event',
				'allowed_container_element' => 'vc_row',
				'params'	=>array(
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Custom CSS class", 'mascot-core' ),
						"param_name"	=> "custom_css_class",
						"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Display Type", 'mascot-core' ),
						"param_name"	=> "display_type",
						"description"	=> "",
						'value'			=> array(
							esc_html__( 'List - Vertical ', 'mascot-core' )			=> 'list-vertical',
							esc_html__( 'List - Vertical Slide', 'mascot-core' )	=> 'list-vertical-slide',
							esc_html__( 'Grid', 'mascot-core' )						=> 'grid',
							esc_html__( 'Masonry', 'mascot-core' )					=> 'masonry',
							esc_html__( 'Carousel', 'mascot-core' )					=> 'carousel',
							esc_html__( 'Fullwidth', 'mascot-core' )				=> 'fullwidth',
							esc_html__( 'Current Theme Style', 'mascot-core' )			=> 'current-theme'
						),
						'save_always'   => true,
						'admin_label'   => true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Columns Layout", 'mascot-core' ),
						"param_name"	=> "columns",
						"description"	=> esc_html__( 'Define Columns Layout for Grid/Carousel.', 'mascot-core' ),
						'value'			=> array(
							'1'  =>  '1',
							'2'  =>  '2',
							'3'  =>  '3',
							'4'  =>  '4',
							'5'  =>  '5',
							'6'  =>  '6',
						),
						'std'			=> 3,
						'dependency'	=> array('element' => 'display_type', 'value' => array('grid', 'masonry', 'carousel') ),
						'save_always'   => true,
						'admin_label'   => true,
					),

					vc_map_add_css_animation(),







					//List - Vertical Options
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Left Thumbnail", 'mascot-core' ),
						"param_name"	=> "vertical_show_left_thumb",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'No', 'mascot-core' )	=> 'false',
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
						),
						'std'			=> 'false',
						'dependency'	=> array('element' => 'display_type', 'value' => array('list-vertical', 'list-vertical-slide')),
						'group'			=> $group_list_vertical_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Left Thumbnail Image Size", 'mascot-core' ),
						"param_name"	=> "vertical_left_thumb_image_size",
						'description'   => '',
						'value'			=> mascot_core_charitab_get_available_image_sizes_for_vc(),
						'std'			=> 'charitab_mascot_square_120',
						'save_always'   => true,
						'dependency'	=> array('element' => 'vertical_show_left_thumb', 'value' => 'true'),
						'group'			=> $group_list_vertical_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Left Date", 'mascot-core' ),
						"param_name"	=> "vertical_show_left_date",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'dependency'	=> array('element' => 'display_type', 'value' => array('list-vertical', 'list-vertical-slide')),
						'group'			=> $group_list_vertical_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Make Left Block Theme Colored?", 'mascot-core' ),
						"param_name"	=> "vertical_left_date_block_theme_colored",
						'description'   => '',
						'value'			=> mascot_core_charitab_theme_color_list_vc(),
						'std'   		=> '1',
						'dependency'	=> array('element' => 'vertical_show_left_date', 'value' => 'true'),
						'save_always'   => true,
						'group'			=> $group_list_vertical_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Left Block Style", 'mascot-core' ),
						"param_name"	=> "vertical_left_date_block_size",
						"description"	=> "",
						'value'			=> array(
							esc_html__( 'Default - Big Size', 'mascot-core' )	=> 'left-block-big',
							esc_html__( 'Medium Size', 'mascot-core' )			=> 'left-block-medium',
							esc_html__( 'Small Size', 'mascot-core' )			=> 'left-block-small',
						),
						'dependency'	=> array('element' => 'display_type', 'value' => array('list-vertical', 'list-vertical-slide')),
						'group'			=> $group_list_vertical_options
					),
					array(
						'type'			=> 'checkbox',
						"heading"		=> esc_html__( "Make Left Block Bordered?", 'mascot-core' ),
						"param_name"	=> "vertical_left_date_block_border",
						'description'   => '',
						'dependency'	=> array('element' => 'display_type', 'value' => array('list-vertical', 'list-vertical-slide')),
						'group'			=> $group_list_vertical_options
					),






					//List - Vertical Slide Options
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Number of Minimum Sliding Items", 'mascot-core' ),
						"param_name"	=> "vertical_slide_minslides",
						'value'			=> 3,
						'dependency'	=> array('element' => 'display_type', 'value' => array('list-vertical-slide')),
						'group'			=> $group_list_vertical_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Autoplay", 'mascot-core' ),
						"param_name"	=> "vertical_slide_autoplay",
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'dependency'	=> array('element' => 'display_type', 'value' => array('list-vertical-slide')),
						'group'			=> $group_list_vertical_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Navigation Arrow", 'mascot-core' ),
						"param_name"	=> "vertical_slide_show_navigation",
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'dependency'	=> array('element' => 'display_type', 'value' => array('list-vertical-slide')),
						'group'			=> $group_list_vertical_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Navigation Arrow Position", 'mascot-core' ),
						"param_name"	=> "vertical_slide_navigation_arrow_position",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Bottom', 'mascot-core' )	=> 'bottom',
							esc_html__( 'Top', 'mascot-core' )		=> 'top',
						),
						'dependency'	=> array('element' => 'vertical_slide_show_navigation', 'value' => 'true'),
						'group'			=> $group_list_vertical_options
					),










					//Carousel Options
					mascot_core_charitab_get_owl_carousel_arraylist( 1, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 2, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 3, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 4, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 5, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 6, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 7, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 8, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 9, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 10, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),


					//Query Options
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Number of Items to Query from Database", 'mascot-core' ),
						"param_name"	=> "total_items",
						"description"	=> esc_html__( 'How many items do you wish to show? Put -1 to show all. Default 3', 'mascot-core' ),
						'value'			=> 3,
						'admin_label'	=> true,
						'group'			=> $group_query_options
					),
					array(
						'type'			=> 'checkbox',
						"heading"		=> esc_html__( "Category", 'mascot-core' ),
						"param_name"	=> "category",
						"description"	=> esc_html__( 'Choose a category to pull from.', 'mascot-core' ),
						'value'			=> $categories_array,
						'group'			=> $group_query_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Order By", 'mascot-core' ),
						"param_name"	=> "order_by",
						"description"	=> esc_html__( 'Select how to sort retrieved posts.', 'mascot-core' ),
						'value'			=> array(
							esc_html__( 'Date', 'mascot-core' )		=> 'date',
							esc_html__( 'Title', 'mascot-core' )		=> 'title',
							esc_html__( 'Popular', 'mascot-core' )	=> 'popular',
							esc_html__( 'Ending', 'mascot-core' )		=> 'ending',
						),
						'std'			=> $orderby_parameters_list[ 'Date' ],
						'group'			=> $group_query_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Order", 'mascot-core' ),
						"param_name"	=> "order",
						"description"	=> esc_html__( 'Descending or Ascending order.', 'mascot-core' ),
						'value'			=> array(
							esc_html__( 'Descending', 'mascot-core' )	=> 'DESC',
							esc_html__( 'Ascending', 'mascot-core' )	=> 'ASC',
						),
						'group'			=> $group_query_options
					),



					//Content Options
					
					//Category Filter
					mascot_core_charitab_get_cat_filter_arraylist( 1, $group_content_options, array('element' => 'display_type', 'value' => array('grid', 'masonry', 'carousel') ) ),
					mascot_core_charitab_get_cat_filter_arraylist( 2, $group_content_options ),
					mascot_core_charitab_get_cat_filter_arraylist( 3, $group_content_options ),

					
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Thumbnail", 'mascot-core' ),
						"param_name"	=> "show_thumb",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'dependency'	=> array('element' => 'display_type', 'value' => array('grid', 'masonry', 'carousel') ),
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Thumbnail Image Size", 'mascot-core' ),
						"param_name"	=> "feature_thumb_image_size",
						'description'   => '',
						'value'			=> mascot_core_charitab_get_available_image_sizes_for_vc(),
						'std'			=> 'post-thumbnail',
						'save_always'   => true,
						'dependency'	=> array('element' => 'show_thumb', 'value' => 'true'),
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Title", 'mascot-core' ),
						"param_name"	=> "show_title",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Excerpt", 'mascot-core' ),
						"param_name"	=> "show_excerpt",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Excerpt Length", 'mascot-core' ),
						"param_name"	=> "excerpt_length",
						"description"	=> esc_html__( 'Number of words to display. Example: 25. Default all.', 'mascot-core' ),
						'dependency'	=> array('element' => 'show_excerpt', 'value' => 'true'),
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Meta", 'mascot-core' ),
						"param_name"	=> "show_meta",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'checkbox',
						"heading"		=> esc_html__( "Choose Meta", 'mascot-core' ),
						"param_name"	=> "meta_options",
						"description"	=> esc_html__( 'Enable/Disabling this option will show/hide each Post Meta.', 'mascot-core' ),
						'value'			=> array(
							esc_html__( 'Show Date Over Image', 'mascot-core' )	=> 'show-date-over-image',
							esc_html__( 'Show Full Date & Time', 'mascot-core' )	=> 'show-full-date',
							esc_html__( 'Show Only Time', 'mascot-core' )			=> 'show-time',
							esc_html__( 'Show Venue', 'mascot-core' )				=> 'show-venue',
							esc_html__( 'Show Organizer', 'mascot-core' )			=> 'show-organizer',
						),
						'std'			=> 'show-date-over-image,show-time',
						'save_always'   => true,
						'dependency'	=> array('element' => 'show_meta', 'value' => 'true'),
						'group'			=> $group_content_options
					),





					
					//Button
					mascot_core_charitab_get_viewdetails_button_arraylist( 1, $group_button_options ),
					mascot_core_charitab_get_viewdetails_button_arraylist( 2, $group_button_options ),

					//button options
					mascot_core_charitab_get_button_arraylist( 1, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 2, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 3, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 4, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 5, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 6, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 7, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 8, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 9, $group_button_options ),

					//Loadmore Button options
					mascot_core_charitab_get_viewdetails_button_arraylist( 1, $group_loadmore_button_options,  esc_html__( "Load More", 'mascot-core' ), 'loadmore_', 'false' ),
					mascot_core_charitab_get_viewdetails_button_arraylist( 2, $group_loadmore_button_options,  esc_html__( "Load More", 'mascot-core' ), 'loadmore_', 'false' ),
					$array = array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Loading Text", 'mascot-core' ),
						"param_name"	=> "loadmore_button_loading_text",
						'std'			=> esc_html__( "Loading...", 'mascot-core' ),
						'save_always'   => true,
						'group'			=> $group_loadmore_button_options
					),
					mascot_core_charitab_get_button_arraylist( 1, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 2, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 3, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 4, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 5, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 6, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 7, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 8, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 9, $group_loadmore_button_options, 'loadmore_' ),

					mascot_core_charitab_vc_add_css_editor(),

				)
			);
			vc_map( $vc_map );

			//Modify vc_map from themes
			if( function_exists('mascot_core_charitab_sc_tribe_events_vc_map_modifier') ) {
				mascot_core_charitab_sc_tribe_events_vc_map_modifier( $this->shortcode_base );
			}
		}
	}

	/**
	 * Renders shortcodes HTML
	 */
	public function render( $attr, $content = null ) {

		//Render Shortcode from themes
		if( function_exists('mascot_core_charitab_sc_tribe_events_render') && class_exists( 'Tribe__Events__Main') && function_exists('vc_map') ) {
			return mascot_core_charitab_sc_tribe_events_render( $attr, $content, null );
		}
		
	}
}