<?php
//https://www.cssscript.com/demo/responsive-horizontal-vertical-timeline/
if(function_exists('vc_map')) {
	add_action( 'init', 'mascot_core_charitab_reg_shortcodes_timeline_horizontal_vertical', 998 );
}
function mascot_core_charitab_reg_shortcodes_timeline_horizontal_vertical() {
	class WPBakeryShortCode_tmvc_Timeline_Horizontal_Vertical  extends WPBakeryShortCodesContainer {}
	vc_map( array(
		"name" =>  __( 'Timeline - Horizontal Vertical', 'mascot-core' ),
		"base" => "tmvc_timeline_horizontal_vertical",
		"as_parent" => array('only' => 'tmvc_timeline_horizontal_vertical_each_block'),
		"content_element" => true,
		"category" => esc_html__( 'by TM', 'mascot-core' ),
		"icon" => 'mascot-vc-icons vc-icon-timeline-horizontal-vertical',
		"show_settings_on_create" => false,
		"js_view" => 'VcColumnView',
		'params' => array(
			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "Mode", 'mascot-core' ),
				"param_name"	=> "mode",
				"description"	=> esc_html__( 'Choose whether the timeline should be vertical or horizontal.', 'mascot-core' ),
				'value'			=> array(
					esc_html__( 'Horizontal', 'mascot-core' )	=> 'horizontal',
					esc_html__( 'Vertical', 'mascot-core' )		=> 'vertical',
				),
				'admin_label'   => true,
				'save_always'   => true,
			),
			array(
				'type'			=> 'textfield',
				"heading"		=> esc_html__( "Force Vertical Mode", 'mascot-core' ),
				"param_name"	=> "force_vertical_mode",
				'std'			=> '800',
				"description"	=> esc_html__( 'When using the timeline in horizontal mode, define at which viewport width it should revert to vertical mode.', 'mascot-core' ),
				'admin_label'   => true,
				'save_always'   => true,
				'dependency'	=> array('element' => 'mode', 'value' => 'horizontal'),
			),
			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "Horizontal Start Position", 'mascot-core' ),
				"param_name"	=> "horizontal_start_position",
				"description"	=> esc_html__( 'When using the timeline in horizontal mode, define the vertical alignment of the first item.', 'mascot-core' ),
				'value'			=> array(
					esc_html__( 'Top', 'mascot-core' )	=> 'top',
					esc_html__( 'Bottom', 'mascot-core' )		=> 'bottom',
				),
				'admin_label'   => true,
				'save_always'   => true,
				'dependency'	=> array('element' => 'mode', 'value' => 'horizontal'),
			),
			array(
				'type'			=> 'textfield',
				"heading"		=> esc_html__( "Move Items", 'mascot-core' ),
				"param_name"	=> "move_items",
				'std'			=> '1',
				"description"	=> esc_html__( 'When using the timeline in horizontal mode, define how many items to move when clicking a navigation button.', 'mascot-core' ),
				'admin_label'   => true,
				'save_always'   => true,
				'dependency'	=> array('element' => 'mode', 'value' => 'horizontal'),
			),
			array(
				'type'			=> 'textfield',
				"heading"		=> esc_html__( "Start Index", 'mascot-core' ),
				"param_name"	=> "start_index",
				'std'			=> '0',
				"description"	=> esc_html__( 'When using the timeline in horizontal mode, define which item the timeline should start at.', 'mascot-core' ),
				'admin_label'   => true,
				'save_always'   => true,
				'dependency'	=> array('element' => 'mode', 'value' => 'horizontal'),
			),
			array(
				'type'			=> 'textfield',
				"heading"		=> esc_html__( "Visible Items", 'mascot-core' ),
				"param_name"	=> "visible_items",
				'std'			=> '4',
				"description"	=> esc_html__( 'If using the timeline in horizontal mode, define how many items are visible in the viewport.', 'mascot-core' ),
				'admin_label'   => true,
				'save_always'   => true,
				'dependency'	=> array('element' => 'mode', 'value' => 'horizontal'),
			),



			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "vertical Start Position", 'mascot-core' ),
				"param_name"	=> "vertical_start_position",
				"description"	=> esc_html__( 'When using the timeline in vertical mode, define the alignment of the first item.', 'mascot-core' ),
				'value'			=> array(
					esc_html__( 'Left', 'mascot-core' )		=> 'left',
					esc_html__( 'Right', 'mascot-core' )	=> 'right',
				),
				'admin_label'   => true,
				'save_always'   => true,
				'dependency'	=> array('element' => 'mode', 'value' => 'vertical'),
			),
			array(
				'type'			=> 'textfield',
				"heading"		=> esc_html__( "Vertical Trigger", 'mascot-core' ),
				"param_name"	=> "vertical_trigger",
				'std'			=> '150px',
				"description"	=> esc_html__( 'When using the timeline in vertical mode, define the distance from the bottom of the screen, in percent or pixels, that the items slide into view.', 'mascot-core' ),
				'admin_label'   => true,
				'save_always'   => true,
				'dependency'	=> array('element' => 'mode', 'value' => 'vertical'),
			),

		)
	) );


	class WPBakeryShortCode_tmvc_Timeline_Horizontal_Vertical_Each_Block  extends WPBakeryShortCodesContainer {}
	vc_map( array(
		"name" =>  __( 'Each Timeline Block', 'mascot-core' ),
		"base" => "tmvc_timeline_horizontal_vertical_each_block",
		"as_parent" => array('only' => 'tmvc_timeline_horizontal_vertical_each_block_content'),
		"as_child" => array('only' => 'tmvc_timeline_horizontal_vertical'),
		"content_element" => true,
		"category" => esc_html__( 'by TM', 'mascot-core' ),
		"icon" => 'mascot-vc-icons vc-icon-timeline-horizontal-vertical-b',
		"show_settings_on_create" => true,
		"js_view" => 'VcColumnView',
		"params" => array(
		)
	) );





	class WPBakeryShortCode_tmvc_Timeline_Horizontal_Vertical_Each_Block_Content  extends WPBakeryShortCodesContainer {}
	vc_map( array(
		"name" =>  __( 'Timeline Content', 'mascot-core' ),
		"base" => "tmvc_timeline_horizontal_vertical_each_block_content",
		"as_parent" => array('except' => 'vc_row, vc_accordion'),
		"as_child" => array('only' => 'tmvc_timeline_horizontal_vertical_each_block'),
		"content_element" => true,
		"category" => esc_html__( 'by TM', 'mascot-core' ),
		"icon" => 'mascot-vc-icons vc-icon-timeline-horizontal-vertical-c',
		"show_settings_on_create" => true,
		"js_view" => 'VcColumnView',
		"params" => array(
			array(
				"type"			=> 'dropdown',
				"heading"		=> esc_html__( "Text Typography", 'mascot-core' ) ,
				"param_name"	=> "section_typo",
				"description"	=> esc_html__( "Define the color typography of the text of this block.", 'mascot-core' ) ,
				"value" => array(
					esc_html__( 'Default', 'mascot-core' ) => '',
					esc_html__( 'Light Text - on Dark Background', 'mascot-core' ) => 'section-typo-light',
					esc_html__( 'Dark Text - on White Background', 'mascot-core' ) => 'section-typo-dark',
				) ,
				"weight" => "99"
			),
			mascot_core_charitab_vc_add_css_editor(),
		)
	) );
}