<?php
if(function_exists('vc_map')) {
	add_action( 'init', 'mascot_core_charitab_reg_shortcodes_timeline_cd_vertical', 998 );
}
function mascot_core_charitab_reg_shortcodes_timeline_cd_vertical() {
	class WPBakeryShortCode_tmvc_Timeline_CD_Vertical  extends WPBakeryShortCodesContainer {}
	vc_map( array(
		"name" =>  __( 'Timeline - Responsive Vertical (CD)', 'mascot-core' ),
		"base" => "tmvc_timeline_cd_vertical",
		"as_parent" => array('only' => 'tmvc_timeline_cd_vertical_each_block'),
		"content_element" => true,
		"category" => esc_html__( 'by TM', 'mascot-core' ),
		"icon" => 'mascot-vc-icons vc-icon-timeline-cd-vertical',
		"show_settings_on_create" => false,
		"js_view" => 'VcColumnView',
		'params' => array(
		)
	) );


	class WPBakeryShortCode_tmvc_Timeline_CD_Vertical_Each_Block  extends WPBakeryShortCodesContainer {}
	vc_map( array(
		"name" =>  __( 'Each Timeline Block', 'mascot-core' ),
		"base" => "tmvc_timeline_cd_vertical_each_block",
		"as_parent" => array('only' => 'tmvc_timeline_cd_vertical_each_block_left, tmvc_timeline_cd_vertical_each_block_right'),
		"as_child" => array('only' => 'tmvc_timeline_cd_vertical'),
		"content_element" => true,
		"category" => esc_html__( 'by TM', 'mascot-core' ),
		"icon" => 'mascot-vc-icons vc-icon-timeline-cd-vertical-b',
		"show_settings_on_create" => true,
		"js_view" => 'VcColumnView',
		"params" => array(
			array(
				'type'			=> 'checkbox',
				"heading"		=> esc_html__( "Reverse Left Right Blocks?", 'mascot-core' ),
				"param_name"	=> "reverse_blocks",
				'description'	=> '',
			),
			array(
				"type" => "attach_image",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( 'Timeline Thumb Image', 'mascot-core' ),
				"param_name" => "timeline_thumb_image",
				"value" => "",
				"description" => ""
			),

			array(
				'type'			=> 'textfield',
				"heading"		=> esc_html__( "Timeline Thumb Text", 'mascot-core' ),
				"param_name"	=> "timeline_thumb_image_text",
			),
			array(
				'type'			=> 'colorpicker',
				"heading"		=> esc_html__( "Timeline Thumb Background Color", 'mascot-core' ),
				"param_name"	=> "timeline_thumb_custom_bg_color",
				"value"		 	=> '',
			),
			array(
				'type'			=> 'colorpicker',
				"heading"		=> esc_html__( "Timeline Thumb Text Color", 'mascot-core' ),
				"param_name"	=> "timeline_thumb_custom_text_color",
				"value"		 	=> '',
			),
		)
	) );





	class WPBakeryShortCode_tmvc_Timeline_CD_Vertical_Each_Block_Left  extends WPBakeryShortCodesContainer {}
	vc_map( array(
		"name" =>  __( 'Timeline Content Left', 'mascot-core' ),
		"base" => "tmvc_timeline_cd_vertical_each_block_left",
		"as_parent" => array('except' => 'vc_row, vc_accordion'),
		"as_child" => array('only' => 'tmvc_timeline_cd_vertical_each_block'),
		"content_element" => true,
		"category" => esc_html__( 'by TM', 'mascot-core' ),
		"icon" => 'mascot-vc-icons vc-icon-timeline-cd-vertical-l',
		"show_settings_on_create" => true,
		"js_view" => 'VcColumnView',
		"params" => array(
			array(
				"type"			=> 'dropdown',
				"heading"		=> esc_html__( "Text Typography", 'mascot-core' ) ,
				"param_name"	=> "section_typo",
				"description"	=> esc_html__( "Define the color typography of the text of this block.", 'mascot-core' ) ,
				"value" => array(
					esc_html__( 'Default', 'mascot-core' ) => '',
					esc_html__( 'Light Text - on Dark Background', 'mascot-core' ) => 'section-typo-light',
					esc_html__( 'Dark Text - on White Background', 'mascot-core' ) => 'section-typo-dark',
				) ,
				"weight" => "99"
			),
			mascot_core_charitab_vc_add_css_editor(),
		)
	) );


	class WPBakeryShortCode_tmvc_Timeline_CD_Vertical_Each_Block_Right  extends WPBakeryShortCodesContainer {}
	vc_map( array(
		"name" =>  __( 'Timeline Content Right', 'mascot-core' ),
		"base" => "tmvc_timeline_cd_vertical_each_block_right",
		"as_parent" => array('except' => 'vc_row, vc_accordion'),
		"as_child" => array('only' => 'tmvc_timeline_cd_vertical_each_block'),
		"content_element" => true,
		"category" => esc_html__( 'by TM', 'mascot-core' ),
		"icon" => 'mascot-vc-icons vc-icon-timeline-cd-vertical-r',
		"show_settings_on_create" => false,
		"js_view" => 'VcColumnView',
		"params" => array(
			array(
				"type"			=> 'dropdown',
				"heading"		=> esc_html__( "Text Typography", 'mascot-core' ) ,
				"param_name"	=> "section_typo",
				"description"	=> esc_html__( "Define the color typography of the text of this block.", 'mascot-core' ) ,
				"value" => array(
					esc_html__( 'Default', 'mascot-core' ) => '',
					esc_html__( 'Light Text - on Dark Background', 'mascot-core' ) => 'section-typo-light',
					esc_html__( 'Dark Text - on White Background', 'mascot-core' ) => 'section-typo-dark',
				) ,
				"weight" => "99"
			),
			mascot_core_charitab_vc_add_css_editor(),
		)
	) );
}