<?php
if(function_exists('vc_map')) {
	add_action( 'init', 'mascot_core_charitab_reg_shortcodes_page_piling_slider', 998 );
}
function mascot_core_charitab_reg_shortcodes_page_piling_slider() {
	class WPBakeryShortCode_tmvc_Page_Piling_Slider  extends WPBakeryShortCodesContainer {}
	vc_map( array(
		"name" =>  __( 'Slider - Page Piling', 'mascot-core' ),
		"base" => "tmvc_page_piling_slider",
		"as_parent" => array('only' => 'tmvc_page_piling_slider_section'),
		"content_element" => true,
		"category" => esc_html__( 'by TM', 'mascot-core' ),
		"icon" => 'mascot-vc-icons vc-icon-full-page-slider',
		"show_settings_on_create" => true,
		"js_view" => 'VcColumnView',
		'params' => array(
			array(
				'type'			=> 'checkbox',
				"heading"		=> esc_html__( "Show Anchor Menu", 'mascot-core' ),
				"param_name"	=> "show_anchor_menu",
			),
			array(
				'type'       => 'textfield',
				'heading'    => esc_html__('Anchor Menu Items', 'mascot-core'),
				'param_name' => 'anchor_menu',
				"description"	=> esc_html__( 'Put menu items seperated by comma. As for example: Home, Services, Contact', 'mascot-core' ),
				'dependency'	=> array('element' => 'show_anchor_menu', 'value' => 'true' ),
			),
			array(
				'type'			=> 'checkbox',
				"heading"		=> esc_html__( "Show Navigation Bullet Menu", 'mascot-core' ),
				"param_name"	=> "show_navigation_bullet_menu",
				'std'			=> 'true',
			),
			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "Navigation Position", 'mascot-core' ),
				"param_name"	=> "navigation_position",
				'desc'		  => '',
				'value'			=> array(
					esc_html__( 'Right', 'mascot-core' )	=>	'right',
					esc_html__( 'Left', 'mascot-core' )		=>	'left',
				),
				'std'			=> 'right',
				'dependency'	=> array('element' => 'show_navigation_bullet_menu', 'value' => 'true' ),
			),
			array(
				'type'			=> 'checkbox',
				"heading"		=> esc_html__( "Show Tooltips on Navigation Bullet Menu", 'mascot-core' ),
				"param_name"	=> "show_tooltips_on_navigation_bullet_menu",
				'std'			=> 'false',
			),
			array(
				'type'       => 'textfield',
				'heading'    => esc_html__('Tooltips on Navigation Bullets', 'mascot-core'),
				'param_name' => 'tooltips_on_navigation',
				"description"	=> esc_html__( 'Put Tooltips seperated by comma. As for example: Home, Services, Contact', 'mascot-core' ),
				'dependency'	=> array('element' => 'show_tooltips_on_navigation_bullet_menu', 'value' => 'true' ),
			),
			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "Scrolling Direction", 'mascot-core' ),
				"param_name"	=> "scrolling_direction",
				'desc'		  => '',
				'value'			=> array(
					esc_html__( 'Vertical', 'mascot-core' )	=>	'vertical',
					esc_html__( 'Horizontal', 'mascot-core' )		=>	'horizontal',
				),
				'std'			=> 'vertical',
			),
			array(
				'type'       => 'textfield',
				'heading'    => esc_html__('Scrolling Speed', 'mascot-core'),
				'param_name' => 'scrolling_speed',
				"description"	=> esc_html__( 'Defines the scrolling speed in milliseconds. Default: 700', 'mascot-core' ),
			),
			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "Easing", 'mascot-core' ),
				"param_name"	=> "easing",
				'description'   => '',
				'value'			=> mascot_core_charitab_jquery_easings_list(),
				'std'			=> 'swing',
				"description"	=> esc_html__( 'Defines the transition effect to use for the vertical and horizontal scrolling. Default: swing', 'mascot-core' ),
				'save_always'   => true,
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__('Loop Top', 'mascot-core'),
				'param_name' => 'looptop',
				'std'			=> 'true',
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__('Loop Bottom', 'mascot-core'),
				'param_name' => 'loopbottom',
				'std'			=> 'true',
			),
		)
	) );


	class WPBakeryShortCode_tmvc_Page_Piling_Slider_Section  extends WPBakeryShortCodesContainer {}
	vc_map( array(
		"name" =>  __( 'Page Piling Slider - Section', 'mascot-core' ),
		"base" => "tmvc_page_piling_slider_section",
		"as_parent" => array('except' => 'vc_row, vc_accordion'),
		"as_child" => array('only' => 'tmvc_page_piling_slider'),
		"content_element" => true,
		"category" => esc_html__( 'by TM', 'mascot-core' ),
		"icon" => 'mascot-vc-icons vc-icon-full-page-slider3',
		"show_settings_on_create" => true,
		"js_view" => 'VcColumnView',
		"params" => array(
			array(
				"type" => "colorpicker",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( 'Background Color', 'mascot-core' ),
				"param_name" => "background_color",
				"value" => "",
				"description" => ""
			),
			array(
				"type" => "attach_image",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( 'Background Image', 'mascot-core' ),
				"param_name" => "background_image",
				"value" => "",
				"description" => ""
			),
			array(
				"type" => "textfield",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( 'Padding left/right', 'mascot-core' ),
				"param_name" => "item_padding",
				"value" => "",
				"description" => esc_html__( "Please insert padding in format '10px'", 'mascot-core' ),
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( 'Content Aligment', 'mascot-core' ),
				"param_name" => "alignment",
				"value" => array(
					"left"    	=> "left",
					"right"     => "right",
					"center"      => "center"
				),
				'save_always' => 'true',
				"description" => ""
			),
			array(
				"type" => "dropdown",
				"holder" => "div",
				"class" => "",
				"heading" => esc_html__( 'Header Style', 'mascot-core' ),
				"param_name" => "header_style",
				"value" => array(
					""	=>	"",
					esc_html__( 'Light', 'mascot-core' )	=>	"light",
					esc_html__( 'Dark', 'mascot-core' )	=>	"dark"
				),
				"description" => ""
			)
		)
	) );
}