<?php
namespace MASCOTCORECHARITAB\Shortcodes\SectionTitle;

use MASCOTCORECHARITAB\Shortcodes\Lib;

/**
 * class SC_Section_Title
 * @package MASCOTCORECHARITAB\Shortcodes\SectionTitle;
 */
class SC_Section_Title implements Lib\Mascot_Core_Charitab_Interface_Shortcodes {
	
	/**
	 * @var shortcode_base
	 */
	private $shortcode_base;

	/**
	 * construct
	 */
	public function __construct() {
		$this->shortcode_base = 'tm_section_title';
		add_action('init', array($this, 'MapShortCodeVC'), 998);
	}

	/**
	 * Returns shortcode_base for shortcode
	 */
	public function getShortCodeBase() {
		return $this->shortcode_base;
	}

	/**
	 * Maps shortcode to Visual Composer
	 */
	public function MapShortCodeVC() {
		$group_wow_options = esc_html__( 'Wow Animation Options', 'mascot-core' );
		$title_options = esc_html__( 'Title Options', 'mascot-core' );
		$title_shadow_text_options = esc_html__( 'Title Shadow Text', 'mascot-core' );
		$sub_title_options = esc_html__( 'Sub Title Options', 'mascot-core' );

		if(function_exists('vc_map')) {
			$vc_map = array(
				'name'		=> esc_html__( 'Section Title', 'mascot-core' ),
				'base'		=>$this->shortcode_base,
				'category'	=> 'by TM',
				'icon'		=> 'mascot-vc-icons vc-icon-sectiontitle',
				'allowed_container_element' => 'vc_row',
				'params'	=>array(
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Custom CSS class", 'mascot-core' ),
						"param_name"	=> "custom_css_class",
						"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Design Style", 'mascot-core' ),
						"param_name"	=> "design_style",
						"description"	=> "",
						'value'			=> array(
							esc_html__( "Style 1 - Default", 'mascot-core' )	=> 'style1',
						),
						'save_always'   => true,
						'admin_label'   => true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Text Alignment", 'mascot-core' ),
						"param_name"	=> "text_alignment",
						"description"	=> "",
						'value'			=> mascot_core_charitab_text_alignment_list(),
						'save_always'   => true,
						'admin_label'   => true,
					),


					
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Title Text (Part 1)", 'mascot-core' ),
						"param_name"	=> "title_text",
						"description"	=> "",
						'admin_label'   => true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Make Title Text (Part 1) Theme Colored?", 'mascot-core' ),
						"param_name"	=> "title_part1_theme_colored",
						'description'   => '',
						'value'			=> mascot_core_charitab_theme_color_list_vc(),
					),


					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Title Text (Part 2)", 'mascot-core' ),
						"param_name"	=> "title_text_part2",
						"description"	=> "",
						'admin_label'   => true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Make Title Text (Part 2) Theme Colored?", 'mascot-core' ),
						"param_name"	=> "title_part2_theme_colored",
						'description'   => '',
						'value'			=> mascot_core_charitab_theme_color_list_vc(),
					),


					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Title Text (Part 3)", 'mascot-core' ),
						"param_name"	=> "title_text_part3",
						"description"	=> "",
						'admin_label'   => true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Make Title Text (Part 3) Theme Colored?", 'mascot-core' ),
						"param_name"	=> "title_part3_theme_colored",
						'description'   => '',
						'value'			=> mascot_core_charitab_theme_color_list_vc(),
					),



					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Title Shadow Text", 'mascot-core' ),
						"param_name"	=> "title_shadow_text",
						"description"	=> esc_html__( 'It will be displayed behind the title as a big blurred gray text.', 'mascot-core' ),
						'admin_label'   => true,
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Sub Title Text", 'mascot-core' ),
						"param_name"	=> "sub_title_text",
						"description"	=> esc_html__( 'It will be displayed up/under title.', 'mascot-core' ),
						'admin_label'   => true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Sub Title Position", 'mascot-core' ),
						"param_name"	=> "sub_title_position",
						"description"	=> "",
						'value'			=> array(
							esc_html__( "Above Title", 'mascot-core' )	=> 'above-title',
							esc_html__( "Below Title", 'mascot-core' )	=> 'below-title',
						),
						'save_always'   => true,
						'admin_label'   => true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Horizontal Line Bottom Style", 'mascot-core' ),
						"param_name"	=> "line_bottom_style",
						"description"	=> "",
						'value'			=> array(
							esc_html__( "No", 'mascot-core' )									=> '',
							esc_html__( "Style 1 - Image Icon", 'mascot-core' )					=> 'line-bottom-style1-image-icon',
							esc_html__( "Style 2 - Solid Line", 'mascot-core' )					=> 'line-bottom-style2-solid-line',
							esc_html__( "Style 3 - Bordered Line", 'mascot-core' )				=> 'line-bottom-style3-bordered-line',
							esc_html__( "Style 4 - Attached Double Lines 1", 'mascot-core' )	=> 'line-bottom-style4-attached-double-lines1',
							esc_html__( "Style 5 - Attached Double Lines 2", 'mascot-core' )	=> 'line-bottom-style5-attached-double-lines2',
							esc_html__( "Style 6 - Bold Double Lines", 'mascot-core' )			=> 'line-bottom-style6-bold-double-lines',
							esc_html__( "Style 7 - Double Lines", 'mascot-core' )				=> 'line-bottom-style7-double-lines',
							esc_html__( "Style 8 - Line with Circle", 'mascot-core' )			=> 'line-bottom-style8-line-with-circle',
							esc_html__( "Style 9 - Line with Square", 'mascot-core' )			=> 'line-bottom-style9-line-with-square',
						),
						'save_always'   => true,
						'admin_label'   => true,
					),
					array(
						'type'			=> 'textarea_html',
						"heading"		=> esc_html__( "Paragraph", 'mascot-core' ),
						"param_name"	=> "content",
					),


					//Title Options
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Title Custom CSS Class", 'mascot-core' ),
						"param_name"	=> "title_custom_css_class",
						"description"	=> esc_html__( 'To style Title.', 'mascot-core' ),
						'group'			=> $title_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Title Tag", 'mascot-core' ),
						"param_name"	=> "title_tag",
						"description"	=> "",
						'value'			=> mascot_core_charitab_heading_tag_list(),
						'std'			=> 'h2',
						'admin_label'   => true,
						'save_always'   => true,
						'group'			=> $title_options
					),
					array(
						'type'			=> 'colorpicker',
						"heading"		=> esc_html__( "Text Color", 'mascot-core' ),
						"param_name"	=> "title_text_color",
						"value"		 => '',
						'group'			=> $title_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Font Size", 'mascot-core' ),
						"param_name"	=> "title_font_size",
						"description"	=> "",
						'group'			=> $title_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Line Height", 'mascot-core' ),
						"param_name"	=> "title_line_height",
						"description"	=> "",
						'group'			=> $title_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Letter Spacing", 'mascot-core' ),
						"param_name"	=> "title_letter_spacing",
						"description"	=> "",
						'group'			=> $title_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Font Style", 'mascot-core' ),
						"param_name"	=> "title_font_style",
						"description"	=> "",
						'value'			=> mascot_core_charitab_vc_font_style_list(),
						'group'			=> $title_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Font Weight", 'mascot-core' ),
						"param_name"	=> "title_font_weight",
						"description"	=> "",
						'value'			=> mascot_core_charitab_vc_font_weight_list(),
						'group'			=> $title_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Text Transform", 'mascot-core' ),
						"param_name"	=> "title_text_transform",
						"description"	=> "",
						'value'			=> mascot_core_charitab_vc_text_transform_list(),
						'group'			=> $title_options
					),





					//SubTitle Options
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Sub Title Custom CSS Class", 'mascot-core' ),
						"param_name"	=> "sub_title_custom_css_class",
						"description"	=> esc_html__( 'To style Sub Title.', 'mascot-core' ),
						'group'			=> $sub_title_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Sub Title Tag", 'mascot-core' ),
						"param_name"	=> "subtitle_tag",
						"description"	=> "",
						'value'			=> mascot_core_charitab_heading_tag_list(),
						'std'			=> 'h5',
						'admin_label'   => true,
						'save_always'   => true,
						'group'			=> $sub_title_options
					),
					array(
						'type'			=> 'colorpicker',
						"heading"		=> esc_html__( "Text Color", 'mascot-core' ),
						"param_name"	=> "subtitle_text_color",
						"value"		 => '',
						'group'			=> $sub_title_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Font Size", 'mascot-core' ),
						"param_name"	=> "subtitle_font_size",
						"description"	=> "",
						'group'			=> $sub_title_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Line Height", 'mascot-core' ),
						"param_name"	=> "subtitle_line_height",
						"description"	=> "",
						'group'			=> $sub_title_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Letter Spacing", 'mascot-core' ),
						"param_name"	=> "subtitle_letter_spacing",
						"description"	=> "",
						'group'			=> $sub_title_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Font Style", 'mascot-core' ),
						"param_name"	=> "subtitle_font_style",
						"description"	=> "",
						'value'			=> mascot_core_charitab_vc_font_style_list(),
						'group'			=> $sub_title_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Font Weight", 'mascot-core' ),
						"param_name"	=> "subtitle_font_weight",
						"description"	=> "",
						'value'			=> mascot_core_charitab_vc_font_weight_list(),
						'group'			=> $sub_title_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Text Transform", 'mascot-core' ),
						"param_name"	=> "subtitle_text_transform",
						"description"	=> "",
						'value'			=> mascot_core_charitab_vc_text_transform_list(),
						'group'			=> $sub_title_options
					),




					//Title Shadow Text Options
					array(
						'type'			=> 'colorpicker',
						"heading"		=> esc_html__( "Text Color", 'mascot-core' ),
						"param_name"	=> "title_shadow_text_text_color",
						"value"		 => '',
						'group'			=> $title_shadow_text_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Top (px)", 'mascot-core' ),
						"param_name"	=> "title_shadow_text_top",
						"description"	=> "",
						'group'			=> $title_shadow_text_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Font Size", 'mascot-core' ),
						"param_name"	=> "title_shadow_text_font_size",
						"description"	=> "",
						'group'			=> $title_shadow_text_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Line Height", 'mascot-core' ),
						"param_name"	=> "title_shadow_text_line_height",
						"description"	=> "",
						'group'			=> $title_shadow_text_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Letter Spacing", 'mascot-core' ),
						"param_name"	=> "title_shadow_text_letter_spacing",
						"description"	=> "",
						'group'			=> $title_shadow_text_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Font Style", 'mascot-core' ),
						"param_name"	=> "title_shadow_text_font_style",
						"description"	=> "",
						'value'			=> mascot_core_charitab_vc_font_style_list(),
						'group'			=> $title_shadow_text_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Font Weight", 'mascot-core' ),
						"param_name"	=> "title_shadow_text_font_weight",
						"description"	=> "",
						'value'			=> mascot_core_charitab_vc_font_weight_list(),
						'group'			=> $title_shadow_text_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Text Transform", 'mascot-core' ),
						"param_name"	=> "title_shadow_text_text_transform",
						"description"	=> "",
						'value'			=> mascot_core_charitab_vc_text_transform_list(),
						'group'			=> $title_shadow_text_options
					),



					//Wow Animation Options
					vc_map_add_css_animation(),

					mascot_core_charitab_vc_add_css_editor(),
				)
			);
			vc_map( $vc_map );

			//Modify vc_map from themes
			if( function_exists('mascot_core_charitab_sc_section_title_vc_map_modifier') ) {
				mascot_core_charitab_sc_section_title_vc_map_modifier( $this->shortcode_base );
			}
		}
	}

	/**
	 * Renders shortcodes HTML
	 */
	public function render( $attr, $content = null ) {

		//Render Shortcode from themes
		if( function_exists('mascot_core_charitab_sc_section_title_render') && function_exists('vc_map') ) {
			return mascot_core_charitab_sc_section_title_render( $attr, $content );
		}
		
	}
}