<?php
namespace MASCOTCORECHARITAB\Shortcodes;

use MASCOTCORECHARITAB\Shortcodes\Lib;
use MASCOTCORECHARITAB\Shortcodes\BeforeAfterSlider\SC_Before_After_Slider;
use MASCOTCORECHARITAB\Shortcodes\Blockquote\SC_Blockquote;
use MASCOTCORECHARITAB\Shortcodes\Blog\SC_Blog;
use MASCOTCORECHARITAB\Shortcodes\Button\SC_Button;
use MASCOTCORECHARITAB\Shortcodes\CallToAction\SC_Call_To_Action;
use MASCOTCORECHARITAB\Shortcodes\CharitableCampaigns\SC_Charitable_Campaigns;
use MASCOTCORECHARITAB\Shortcodes\CharitableCampaignCustom\SC_Charitable_Campaign_Custom;
use MASCOTCORECHARITAB\Shortcodes\CountdownTimer\SC_Countdown_Timer;
use MASCOTCORECHARITAB\Shortcodes\CustomColumnsHolder\SC_Custom_Columns_Holder;
use MASCOTCORECHARITAB\Shortcodes\CustomColumnsHolderItem\SC_Custom_Columns_Holder_Item;
use MASCOTCORECHARITAB\Shortcodes\FunFactCounter\SC_FunFact_Counter;
use MASCOTCORECHARITAB\Shortcodes\Dropcaps\SC_Dropcaps;
use MASCOTCORECHARITAB\Shortcodes\GiveCampaigns\SC_Give_Campaigns;
use MASCOTCORECHARITAB\Shortcodes\GiveSingleFormCustom\SC_Give_Single_Form_Custom;
use MASCOTCORECHARITAB\Shortcodes\GoogleMap\SC_Google_Map;
use MASCOTCORECHARITAB\Shortcodes\IconBox\SC_Icon_Box;
use MASCOTCORECHARITAB\Shortcodes\OpeningHours\SC_Opening_Hours;
use MASCOTCORECHARITAB\Shortcodes\OpeningHoursCompressed\SC_Opening_Hours_Compressed;
use MASCOTCORECHARITAB\Shortcodes\PaypalDonation\SC_Paypal_Donation;
use MASCOTCORECHARITAB\Shortcodes\PieChart\SC_Pie_Chart;
use MASCOTCORECHARITAB\Shortcodes\PricingTable\SC_PricingTable;
use MASCOTCORECHARITAB\Shortcodes\ProgressBar\SC_Progress_Bar;
use MASCOTCORECHARITAB\Shortcodes\SectionTitle\SC_Section_Title;
use MASCOTCORECHARITAB\Shortcodes\SocialList\SC_Social_List;
use MASCOTCORECHARITAB\Shortcodes\TribeEvents\SC_Tribe_Events;
use MASCOTCORECHARITAB\Shortcodes\TribeEvents\SC_Tribe_Single_Event;
use MASCOTCORECHARITAB\Shortcodes\VideoPopup\SC_Video_Popup;
use MASCOTCORECHARITAB\Shortcodes\UnorderedList\SC_Unordered_List;
use MASCOTCORECHARITAB\Shortcodes\WCProducts\SC_WC_Products;
use MASCOTCORECHARITAB\Shortcodes\WorkingStepsHolder\SC_Working_Steps_Holder;
use MASCOTCORECHARITAB\Shortcodes\WorkingStepsHolderItem\SC_Working_Steps_Holder_Item;

/**
 * class Loader_Shortcodes
 * @package MASCOTCORECHARITAB\Shortcodes;
 */
class Loader_Shortcodes {
	/**
	 * @var Singleton The reference to *Singleton* instance of this class
	 */
	private static $instance;

	/**
	 * @var array
	 */
	private $allShortCodes = array();
	
	/**
	 * Returns the *Singleton* instance of this class.
	 *
	 * @return Singleton The *Singleton* instance.
	 */
	public static function get_instance()
	{
		if (null === static::$instance) {
			static::$instance = new static();
		}
		
		return static::$instance;
	}

	/**
	 * Protected constructor to prevent creating a new instance of the
	 * *Singleton* via the `new` operator from outside of this class.
	 */
	protected function __construct()
	{
	}

	/**
	 * Private clone method to prevent cloning of the instance of the
	 * *Singleton* instance.
	 *
	 * @return void
	 */
	private function __clone()
	{
	}

	/**
	 * Private unserialize method to prevent unserializing of the *Singleton*
	 * instance.
	 *
	 * @return void
	 */
	private function __wakeup()
	{
	}


	/**
	 * Adds new SC to SC array
	 */
	private function addNewShortCode(Lib\Mascot_Core_Charitab_Interface_Shortcodes $newShortCode) {
		if(!array_key_exists($newShortCode->getShortCodeBase(), $this->allShortCodes)) {
			$this->allShortCodes[$newShortCode->getShortCodeBase()] = $newShortCode;
		}
	}

	/**
	 * List of all SCs to register
	 */
	private function available_shortcodes() {
		$this->addNewShortCode(new SC_Before_After_Slider());
		$this->addNewShortCode(new SC_Blockquote());
		$this->addNewShortCode(new SC_Blog());
		$this->addNewShortCode(new SC_Button());
		$this->addNewShortCode(new SC_Call_To_Action());
		$this->addNewShortCode(new SC_Charitable_Campaigns());
		$this->addNewShortCode(new SC_Charitable_Campaign_Custom());
		$this->addNewShortCode(new SC_Countdown_Timer());
		$this->addNewShortCode(new SC_Custom_Columns_Holder());
		$this->addNewShortCode(new SC_Custom_Columns_Holder_Item());
		$this->addNewShortCode(new SC_Dropcaps());
		$this->addNewShortCode(new SC_FunFact_Counter());
		$this->addNewShortCode(new SC_Give_Campaigns());
		$this->addNewShortCode(new SC_Give_Single_Form_Custom());
		$this->addNewShortCode(new SC_Google_Map());
		$this->addNewShortCode(new SC_Icon_Box());
		$this->addNewShortCode(new SC_Opening_Hours());
		$this->addNewShortCode(new SC_Opening_Hours_Compressed());
		$this->addNewShortCode(new SC_Paypal_Donation());
		$this->addNewShortCode(new SC_Pie_Chart());
		$this->addNewShortCode(new SC_PricingTable());
		$this->addNewShortCode(new SC_Progress_Bar());
		$this->addNewShortCode(new SC_Section_Title());
		$this->addNewShortCode(new SC_Social_List());
		$this->addNewShortCode(new SC_Tribe_Events());
		$this->addNewShortCode(new SC_Tribe_Single_Event());
		$this->addNewShortCode(new SC_Unordered_List());
		$this->addNewShortCode(new SC_Video_Popup());
		$this->addNewShortCode(new SC_WC_Products());
		$this->addNewShortCode(new SC_Working_Steps_Holder());
		$this->addNewShortCode(new SC_Working_Steps_Holder_Item());
	}


	/**
	 * Calls available_shortcodes method, loops through each SC in array and add it through add_shortcode
	 */
	public function load() {
		$this->available_shortcodes();
		foreach ($this->allShortCodes as $eachShortCode) {
			add_shortcode($eachShortCode->getShortCodeBase(), array($eachShortCode, 'render'));
		}
	}
}

//Create instance of Loader_Shortcodes
$scloader = Loader_Shortcodes::get_instance();
$scloader->load();