<?php
namespace MASCOTCORECHARITAB\Shortcodes\Dropcaps;

use MASCOTCORECHARITAB\Shortcodes\Lib;

/**
 * class SC_dropcaps
 * @package MASCOTCORECHARITAB\Shortcodes\Dropcaps;
 */
class SC_Dropcaps implements Lib\Mascot_Core_Charitab_Interface_Shortcodes {
	
	/**
	 * @var shortcode_base
	 */
	private $shortcode_base;

	/**
	 * construct
	 */
	public function __construct() {
		$this->shortcode_base = 'tm_dropcaps';
		add_action('init', array($this, 'MapShortCodeVC'), 998);
	}

	/**
	 * Returns shortcode_base for shortcode
	 */
	public function getShortCodeBase() {
		return $this->shortcode_base;
	}

	/**
	 * Maps shortcode to Visual Composer
	 */
	public function MapShortCodeVC() {
		$text_options = esc_html__( 'Text Options', 'mascot-core' );
		$footer_cite_options = esc_html__( 'Footer Cite Options', 'mascot-core' );

		if(function_exists('vc_map')) {
			$vc_map = array(
				'name'		=> esc_html__( 'Dropcaps', 'mascot-core' ),
				'base'		=>$this->shortcode_base,
				'category'	=> 'by TM',
				'icon'		=> 'mascot-vc-icons vc-icon-dropcaps',
				'allowed_container_element' => 'vc_row',
				'params'	=>array(
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Custom CSS class", 'mascot-core' ),
						"param_name"	=> "custom_css_class",
						"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
					),
					
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Dropcaps Style", 'mascot-core' ),
						"param_name"	=> "dropcaps_style",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Empty', 'mascot-core' )	=> 'dropcaps-empty',
							esc_html__( 'Fill', 'mascot-core' )		=> 'dropcaps-fill',
						),
						'admin_label'   => true,
						'save_always'   => true,
					),

					array(
						'type'			=> 'textarea',
						"heading"		=> esc_html__( "Text", 'mascot-core' ),
						"param_name"	=> "text",
					),
					array(
						'type'			=> 'colorpicker',
						"heading"		=> esc_html__( "Text Color", 'mascot-core' ),
						"param_name"	=> "text_text_color",
						"value"		 => '',
					),
					array(
						'type'			=> 'colorpicker',
						"heading"		=> esc_html__( "Background Color", 'mascot-core' ),
						"param_name"	=> "bg_color",
						"value"		 => '',
						'dependency'	=> array('element' => 'dropcaps_style', 'value' => 'dropcaps-fill'),
					),


				)
			);
			vc_map( $vc_map );

			//Modify vc_map from themes
			if( function_exists('mascot_core_charitab_sc_dropcaps_vc_map_modifier') ) {
				mascot_core_charitab_sc_dropcaps_vc_map_modifier( $this->shortcode_base );
			}
		}
	}

	/**
	 * Renders shortcodes HTML
	 */
	public function render( $attr, $content = null ) {

		//Render Shortcode from themes
		if( function_exists('mascot_core_charitab_sc_dropcaps_render') && function_exists('vc_map') ) {
			return mascot_core_charitab_sc_dropcaps_render( $attr, $content );
		}
		
	}
}