<?php
if(function_exists('vc_map')) {
	add_action( 'init', 'mascot_core_charitab_reg_shortcodes_charitable_plugin', 998 );
}
function mascot_core_charitab_reg_shortcodes_charitable_plugin() {
	/**
	 * Charitable Login
	 */
	vc_map( array(
		'name'     => esc_html__( 'Charitable Login Form', 'mascot-core' ),
		'base'     => 'charitable_login',
		'description' => esc_html__( 'Front-end Login', 'mascot-core' ),
		'category' => esc_html__( 'by TM', 'mascot-core' ),
		'icon'	   => 'mascot-vc-icons vc-icon-charitable',
		'params'   => array(
			array(
				'type'			=> 'textfield',
				"heading"		=> esc_html__( "Logged in Message", 'mascot-core' ),
				"param_name"	=> "logged_in_message",
				"description"	=> esc_html__( 'You can optionally set the message that will be displayed to users when they are already logged in.', 'mascot-core' ),
				'value'			=> esc_html__( 'You are already logged in!', 'mascot-core' ),
			),
			array(
				'type'			=> 'textfield',
				"heading"		=> esc_html__( "Registration Link Text", 'mascot-core' ),
				"param_name"	=> "registration_link_text",
				"description"	=> esc_html__( 'You can also customize the text used for the link to the registration page. To remove the link to the registration page altogether, set 0.', 'mascot-core' ),
				'value'			=> esc_html__( 'Register', 'mascot-core' ),
			),
			array(
				'type'			=> 'textfield',
				"heading"		=> esc_html__( "Logging Redirect", 'mascot-core' ),
				"param_name"	=> "redirect",
				"description"	=> esc_html__( 'It is also possible to change the default page that people are redirected to after logging in.', 'mascot-core' ),
			),
		)
	) );


	
	/**
	 * Charitable Registration
	 */
	vc_map( array(
		'name'     => esc_html__( 'Charitable Registration Form', 'mascot-core' ),
		'base'     => 'charitable_registration',
		'description' => esc_html__( 'Front-end Registration', 'mascot-core' ),
		'category' => esc_html__( 'by TM', 'mascot-core' ),
		'icon'	   => 'mascot-vc-icons vc-icon-charitable',
		'params'   => array(
			array(
				'type'			=> 'textfield',
				"heading"		=> esc_html__( "Logged in Message", 'mascot-core' ),
				"param_name"	=> "logged_in_message",
				"description"	=> esc_html__( 'You can optionally set the message that will be displayed to users when they are already logged in.', 'mascot-core' ),
				'value'			=> esc_html__( 'You are already logged in!', 'mascot-core' ),
			),
			array(
				'type'			=> 'textfield',
				"heading"		=> esc_html__( "Login Link Text", 'mascot-core' ),
				"param_name"	=> "login_link_text",
				"description"	=> esc_html__( 'You can also customize the text used for the link to the login page. To remove the link to the login page altogether, set 0.', 'mascot-core' ),
				'value'			=> esc_html__( 'Signed up already? Login instead.', 'mascot-core' ),
			),
			array(
				'type'			=> 'textfield',
				"heading"		=> esc_html__( "Registration Redirect", 'mascot-core' ),
				"param_name"	=> "redirect",
				"description"	=> esc_html__( 'By default, the user is redirected to the Profile page after registration or, if the Profile page has not been set up (see below), to the homepage. You can provide a default page for users to be redirected to with the redirect parameter.', 'mascot-core' ),
			),
		)
	) );

	/**
	 * Charitable Profile
	 */
	vc_map( array(
		'name'     => esc_html__( 'Charitable Profile Form', 'mascot-core' ),
		'base'     => 'charitable_profile',
		'description' => esc_html__( 'Manage Profile Information', 'mascot-core' ),
		'category' => esc_html__( 'by TM', 'mascot-core' ),
		'icon'	   => 'mascot-vc-icons vc-icon-charitable',
		'params'   => array(),
		'show_settings_on_create'	=> false,
	) );


	/**
	 * Donations Table
	 */
	vc_map( array(
		'name'     => esc_html__( 'Charitable Donations Table', 'mascot-core' ),
		'base'     => 'charitable_my_donations',
		'description' => esc_html__( 'History of Donations', 'mascot-core' ),
		'category' => esc_html__( 'by TM', 'mascot-core' ),
		'icon'	   => 'mascot-vc-icons vc-icon-charitable',
		'params'   => array(),
		'show_settings_on_create'	=> false,
	) );

	
	/**
	 * Charitable Donation Form
	 */
	vc_map( array(
		'name'     => esc_html__( 'Charitable Donation Form (Single)', 'mascot-core' ),
		'base'     => 'charitable_donation_form',
		'description' => esc_html__( 'Add Your Donation Form to a Page', 'mascot-core' ),
		'category' => esc_html__( 'by TM', 'mascot-core' ),
		'icon'	   => 'mascot-vc-icons vc-icon-charitable',
		'params'   => array(
			array(
				'type'			=> 'textfield',
				"heading"		=> esc_html__( "Custom CSS Class", 'mascot-core' ),
				"param_name"	=> "custom_css_class",
				"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
				'admin_label'   => true,
			),
			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "Choose Donation Form to Display", 'mascot-core' ),
				"param_name"	=> "campaign_id",
				//"description"	=> esc_html__( 'The "campaign_id" is a required attribute for this shortcode. The "campaign_id" should be the post ID of a published donation form.', 'mascot-core' ),
				'value'			=> mascot_core_charitab_get_post_list_array_by_post_type( 'campaign', true ),
				'admin_label'   => true,
			),
		)
	) );



	/**
	 * Charitable Donation Stats 
	 */
	//collect vc icon pack
	$group_icon_options = esc_html__( 'Icon Options', 'mascot-core' );
	$vc_icon_pack_array = array();
	if( function_exists('charitab_mascot_get_vc_icon_pack_array') ) {
		$vc_icon_pack_array = charitab_mascot_get_vc_icon_pack_array( array('element' => 'icon_type', 'value' => array('font-icon')), $group_icon_options );
	}
	$params_part1 = array(
		array(
			'type'			=> 'textfield',
			"heading"		=> esc_html__( "Custom CSS class", 'mascot-core' ),
			"param_name"	=> "custom_css_class",
			"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
		),
		array(
			'type'			=> 'dropdown',
			"heading"		=> esc_html__( "Display Type", 'mascot-core' ),
			"param_name"	=> "display",
			'value'			=> array(
				esc_html__( 'Total Amount Raised', 'mascot-core' )					=> 'total',
				esc_html__( 'Total Raised in Relation to a Goal', 'mascot-core' )	=> 'progress',
				esc_html__( 'The Number of Donors', 'mascot-core' )					=> 'donors',
				esc_html__( 'The Number of Donations', 'mascot-core' )				=> 'donations'
			),
			'save_always'   => true,
			'admin_label'   => true,
		),
		array(
			'type'			=> 'textfield',
			"heading"		=> esc_html__( "Campaigns IDs", 'mascot-core' ),
			"param_name"	=> "campaigns",
			"description"	=> esc_html__( 'A comma-separated list of campaign IDs. If not provided, all campaigns will be included. By default, this is empty (all campaigns are included).', 'mascot-core' ),
			'admin_label'   => true,
		),
		array(
			'type'			=> 'textfield',
			"heading"		=> esc_html__( "Goal", 'mascot-core' ),
			"param_name"	=> "goal",
			"description"	=> esc_html__( 'Required if Display Type = Total Raised. The goal that your progress is measured in relation to. By default, this is empty.', 'mascot-core' ),
			'dependency'	=> array('element' => 'display', 'value' => 'progress'),
			'admin_label'   => true,
		),

		array(
			'type'			=> 'dropdown',
			"heading"		=> esc_html__( "Stat Tag", 'mascot-core' ),
			"param_name"	=> "stat_tag",
			'description'   => esc_html__( 'Default: H3', 'mascot-core' ),
			'value'			=> mascot_core_charitab_heading_tag_list(),
			'std'			=> 'h3',
			'save_always'   => true,
			'admin_label'   => true,
		),

		array(
			'type'			=> 'textfield',
			"heading"		=> esc_html__( "Stat Bottom-line Text", 'mascot-core' ),
			"param_name"	=> "stat_bottomline_text",
		),
		array(
			'type'			=> 'dropdown',
			"heading"		=> esc_html__( "Text Alignment", 'mascot-core' ),
			"param_name"	=> "text_alignment",
			"description"	=> "",
			'value'			=> mascot_core_charitab_text_alignment_list(),
			'save_always'   => true,
			'admin_label'   => true,
		),
		array(
			'type'			=> 'dropdown',
			"heading"		=> esc_html__( "Icon Type", 'mascot-core' ),
			"param_name"	=> "icon_type",
			"description"	=> "Choose font icon or image.",
			'value'			=> array(
				esc_html__( 'Font Icon', 'mascot-core' )		=> 'font-icon',
				esc_html__( 'JPG/PNG Image', 'mascot-core' )   	=> 'image'
			),
			'save_always'   => true,
			'group'			=> $group_icon_options
		),
	);

	$merged_fields = array_merge($params_part1, $vc_icon_pack_array);
	$params_part2 = array(
		array(
			'type'			=> 'attach_image',
			"heading"		=> esc_html__( "Upload Image Icon", 'mascot-core' ),
			"param_name"	=> "image_icon",
			"description"	=> esc_html__( 'Upload the custom image icon.', 'mascot-core' ),
			'group'			=> $group_icon_options,
			'dependency'	=> array('element' => 'icon_type', 'value' => 'image'),
		),
		
		array(
			'type'			=> 'dropdown',
			"heading"		=> esc_html__( "Icon Size", 'mascot-core' ),
			"param_name"	=> "icon_size",
			"description"	=> "",
			'value'			=> array(
				esc_html__( 'Default', 'mascot-core' )		=>   '',
				esc_html__( 'Small', 'mascot-core' )		=>   'icon-sm',
				esc_html__( 'Extra Small', 'mascot-core' )	=>   'icon-xs',
				esc_html__( 'Medium', 'mascot-core' )		=>   'icon-md',
				esc_html__( 'Large', 'mascot-core' )		=>   'icon-lg',
				esc_html__( 'Extra Large', 'mascot-core' )	=>   'icon-xl',
			),
			'group'			=> $group_icon_options
		),
		array(
			'type'			=> 'dropdown',
			"heading"		=> esc_html__( "Icon Color", 'mascot-core' ),
			"param_name"	=> "icon_color",
			"description"	=> "",
			'value'			=> array(
				esc_html__( 'Default', 'mascot-core' )  => '',
				esc_html__( 'White', 'mascot-core' )	=> 'icon-white',
				esc_html__( 'Gray', 'mascot-core' )	  	=> 'icon-gray',
				esc_html__( 'Dark', 'mascot-core' )	  	=> 'icon-dark'
			),
			'group'			=> $group_icon_options,
			'save_always'   => true,
		),
		array(
			'type'			=> 'dropdown',
			"heading"		=> esc_html__( "Icon Style", 'mascot-core' ),
			"param_name"	=> "icon_style",
			"description"	=> "",
			'value'			=> array(
				esc_html__( 'Default', 'mascot-core' )   => 'icon-default',
				esc_html__( 'Rounded', 'mascot-core' )   => 'icon-rounded',
				esc_html__( 'Circled', 'mascot-core' )   => 'icon-circled',
			),
			'group'			=> $group_icon_options
		),
		array(
			'type'			=> 'checkbox',
			"heading"		=> esc_html__( "Make Icon Area Bordered?", 'mascot-core' ),
			"param_name"	=> "icon_border_style",
			'description'   => '',
			'group'			=> $group_icon_options
		),
		array(
			'type'			=> 'dropdown',
			"heading"		=> esc_html__( "Make Icon Theme Colored?", 'mascot-core' ),
			"param_name"	=> "icon_theme_colored",
			'description'   => '',
			'value'			=> mascot_core_charitab_theme_color_list_vc(),
			'group'			=> $group_icon_options
		),
		mascot_core_charitab_vc_add_css_editor(),
	);
	$merged_fields = array_merge($merged_fields, $params_part2);

	$vc_map = array(
		'name'		=> esc_html__( 'Charitable Donation Stats', 'mascot-core' ),
		'base'		=> 'tmvc_charitable_donation_stats',
		'description' => esc_html__( 'Show Donation Stats', 'mascot-core' ),
		'category'	=> esc_html__( 'by TM', 'mascot-core' ),
		'icon'		=> 'mascot-vc-icons vc-icon-charitable',
		'params'	=> $merged_fields
	);
	vc_map( $vc_map );
}

add_shortcode( 'tmvc_charitable_donation_stats', 'mascot_core_charitab_sc_charitable_donation_stats' );