<?php
namespace MASCOTCORECHARITAB\Shortcodes\Button;

use MASCOTCORECHARITAB\Shortcodes\Lib;

/**
 * class SC_Button
 * @package MASCOTCORECHARITAB\Shortcodes\Button;
 */
class SC_Button implements Lib\Mascot_Core_Charitab_Interface_Shortcodes {
	
	/**
	 * @var shortcode_base
	 */
	private $shortcode_base;

	/**
	 * construct
	 */
	public function __construct() {
		$this->shortcode_base = 'tm_button';
		add_action('init', array($this, 'MapShortCodeVC'), 998);
	}

	/**
	 * Returns shortcode_base for shortcode
	 */
	public function getShortCodeBase() {
		return $this->shortcode_base;
	}

	/**
	 * Maps shortcode to Visual Composer
	 */
	public function MapShortCodeVC() {
		if(function_exists('vc_map')) {
			$group_icon_options = esc_html__( 'Icon Options', 'mascot-core' );

			$vc_map = array(
				'name'		=> esc_html__( 'Button', 'mascot-core' ),
				'base'		=>$this->shortcode_base,
				'category'	=> 'by TM',
				'icon'		=> 'mascot-vc-icons vc-icon-button',
				'allowed_container_element' => 'vc_row',
				'params'	=>array(
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Custom CSS class", 'mascot-core' ),
						"param_name"	=> "custom_css_class",
						"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Button Text", 'mascot-core' ),
						"param_name"	=> "button_text",
						"description"	=> esc_html__( 'Ex: Read More', 'mascot-core' ),
						'admin_label'   => true,
					),
					array(
						'type'			=> 'vc_link',
						'heading'		=> esc_html__( 'URL (Link)', 'mascot-core' ),
						'param_name'	=> 'link_url',
						'description' 	=> esc_html__( 'Add link to button.', 'mascot-core' ),
					),



					//button options
					mascot_core_charitab_get_button_arraylist( 1 ),
					mascot_core_charitab_get_button_arraylist( 2 ),
					mascot_core_charitab_get_button_arraylist( 3 ),
					mascot_core_charitab_get_button_arraylist( 4 ),
					mascot_core_charitab_get_button_arraylist( 5 ),
					mascot_core_charitab_get_button_arraylist( 6 ),
					mascot_core_charitab_get_button_arraylist( 7 ),
					mascot_core_charitab_get_button_arraylist( 8 ),
					mascot_core_charitab_get_button_arraylist( 9 ),

					vc_map_add_css_animation(),

					//Icon Options
					array(
						'type'			=> 'checkbox',
						"heading"		=> esc_html__( "Add icon?", 'mascot-core' ),
						"param_name"	=> "add_icon",
						'description'   => '',
						'group'			=> $group_icon_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Icon Left", 'mascot-core' ),
						"param_name"	=> "button_icon_left",
						"description"	=> sprintf( esc_html__( 'Icon to the left of your button text. Eg: fa fa-arrow-right. See full list of icons from %1$shere%2$s', 'mascot-core' ), '<a target="_blank" href="' . esc_url( 'http://docs.kodesolution.info/icons/' ) . '">', '</a>' ),
						'dependency'	=> array('element' => 'add_icon', 'value' => 'true'),
						'group'			=> $group_icon_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Icon Right", 'mascot-core' ),
						"param_name"	=> "button_icon_right",
						"description"	=> sprintf( esc_html__( 'Icon to the right of your button text. Eg: fa fa-arrow-right. See full list of icons from %1$shere%2$s', 'mascot-core' ), '<a target="_blank" href="' . esc_url( 'http://docs.kodesolution.info/icons/' ) . '">', '</a>' ),
						'dependency'	=> array('element' => 'add_icon', 'value' => 'true'),
						'group'			=> $group_icon_options
					),

				)
			);
			vc_map( $vc_map );

			//Modify vc_map from themes
			if( function_exists('mascot_core_charitab_sc_button_vc_map_modifier') ) {
				mascot_core_charitab_sc_button_vc_map_modifier( $this->shortcode_base );
			}
		}
	}

	/**
	 * Renders shortcodes HTML
	 */
	public function render( $attr, $content = null ) {

		//Render Shortcode from themes
		if( function_exists('mascot_core_charitab_sc_button_render') && function_exists('vc_map') ) {
			return mascot_core_charitab_sc_button_render( $attr, $content );
		}
		
	}
}