<?php
namespace MASCOTCORECHARITAB\Shortcodes\Blog;

use MASCOTCORECHARITAB\Shortcodes\Lib;

/**
 * class SC_Blog
 * @package MASCOTCORECHARITAB\Shortcodes\Blog;
 */
class SC_Blog implements Lib\Mascot_Core_Charitab_Interface_Shortcodes {
	
	/**
	 * @var shortcode_base
	 */
	private $shortcode_base;

	/**
	 * construct
	 */
	public function __construct() {
		$this->shortcode_base = 'tm_blog';
		add_action('init', array($this, 'MapShortCodeVC'), 998);
	}

	/**
	 * Returns shortcode_base for shortcode
	 */
	public function getShortCodeBase() {
		return $this->shortcode_base;
	}

	/**
	 * Maps shortcode to Visual Composer
	 */
	public function MapShortCodeVC() {
		$group_content_options = esc_html__( 'Content', 'mascot-core' );
		$group_carousel_options = esc_html__( 'Carousel', 'mascot-core' );
		$group_query_options = esc_html__( 'Query Options', 'mascot-core' );
		$group_button_options = esc_html__( 'Button', 'mascot-core' );
		$group_loadmore_button_options = esc_html__( 'Loadmore Button', 'mascot-core' );

		$post_meta_array = array(
			esc_html__( 'Show Author', 'mascot-core' )		=> 'show-post-by-author',
			esc_html__( 'Show Date', 'mascot-core' )			=> 'show-post-date',
			esc_html__( 'Show Category', 'mascot-core' )		=> 'show-post-category',
			esc_html__( 'Show Comments Count', 'mascot-core' )	=> 'show-post-comments-count',
			esc_html__( 'Show Tag', 'mascot-core' )			=> 'show-post-tag',
			esc_html__( 'Show Like Button', 'mascot-core' )	=> 'show-post-like-button'
		);

		$categories_array = mascot_core_charitab_category_list_array_for_vc( 'category' );
		$orderby_parameters_list1 = mascot_core_charitab_orderby_parameters_list();
		$orderby_parameters_list2 = array(
		);
		$orderby_parameters_list = array_merge( $orderby_parameters_list2, $orderby_parameters_list1 );


		if(function_exists('vc_map')) {
			$vc_map = array(
				'name'		=> esc_html__( 'Blog', 'mascot-core' ),
				'base'		=>$this->shortcode_base,
				'category'	=> 'by TM',
				'description' => esc_html__( 'Blog Grid/Carousel', 'mascot-core' ),
				'icon'		=> 'mascot-vc-icons vc-icon-blog',
				'allowed_container_element' => 'vc_row',
				'params'	=>array(
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Custom CSS class", 'mascot-core' ),
						"param_name"	=> "custom_css_class",
						"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Design Style", 'mascot-core' ),
						"param_name"	=> "design_style",
						"description"	=> "",
						'value'			=> array(
							esc_html__( 'Style 1 - Default', 'mascot-core' )	=> 'blog-style1-simple',
							esc_html__( 'Style 2 - Standard', 'mascot-core' )	=> 'blog-style2-standard',
							esc_html__( 'Style 3 - Classic', 'mascot-core' )	=> 'blog-style3-classic',
							esc_html__( 'Style 4 - Modern', 'mascot-core' )		=> 'blog-style4-modern',
							esc_html__( 'Style 5 - Horizontal', 'mascot-core' )	=> 'blog-style5-horizontal',
							esc_html__( 'Style 6 - Current Theme', 'mascot-core' )	=> 'blog-style6-current-theme',
						),
						'save_always'   => true,
						'admin_label'   => true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Display Type", 'mascot-core' ),
						"param_name"	=> "display_type",
						"description"	=> "",
						'value'			=> array(
							esc_html__( 'Grid', 'mascot-core' )		=> 'grid',
							esc_html__( 'Masonry', 'mascot-core' )	=> 'masonry',
							esc_html__( 'Carousel', 'mascot-core' )	=> 'carousel'
						),
						'save_always'   => true,
						'admin_label'   => true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Columns Layout", 'mascot-core' ),
						"param_name"	=> "columns",
						"description"	=> esc_html__( 'Define Columns Layout for Grid/Carousel.', 'mascot-core' ),
						'value'			=> array(
							'1'  =>  '1',
							'2'  =>  '2',
							'3'  =>  '3',
							'4'  =>  '4',
							'5'  =>  '5',
							'6'  =>  '6',
						),
						'std'			=> 3,
						'admin_label'   => true,
					),



					//Carousel Options
					mascot_core_charitab_get_owl_carousel_arraylist( 1, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 2, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 3, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 4, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 5, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 6, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 7, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 8, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 9, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 10, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),


					//Query Options
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Number of Items to Query from Database", 'mascot-core' ),
						"param_name"	=> "total_items",
						"description"	=> esc_html__( 'How many items do you wish to show? Put -1 to show all. Default 3', 'mascot-core' ),
						'value'			=> 3,
						'admin_label'   => true,
						'group'			=> $group_query_options
					),
					array(
						'type'			=> 'checkbox',
						"heading"		=> esc_html__( "Category", 'mascot-core' ),
						"param_name"	=> "category",
						"description"	=> esc_html__( 'Choose a category to pull from.', 'mascot-core' ),
						'value'			=> $categories_array,
						'group'			=> $group_query_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Order By", 'mascot-core' ),
						"param_name"	=> "order_by",
						"description"	=> esc_html__( 'Select how to sort retrieved posts.', 'mascot-core' ),
						'value'			=> $orderby_parameters_list,
						'std'			=> $orderby_parameters_list[ 'Date' ],
						'group'			=> $group_query_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Order", 'mascot-core' ),
						"param_name"	=> "order",
						"description"	=> esc_html__( 'Descending or Ascending order.', 'mascot-core' ),
						'value'			=> array(
							esc_html__( 'Descending', 'mascot-core' )	=> 'DESC',
							esc_html__( 'Ascending', 'mascot-core' )	=> 'ASC',
						),
						'group'			=> $group_query_options
					),



					//Content Options
					
					//Category Filter
					mascot_core_charitab_get_cat_filter_arraylist( 1, $group_content_options, array('element' => 'display_type', 'value' => array('grid', 'masonry', 'carousel') ) ),
					mascot_core_charitab_get_cat_filter_arraylist( 2, $group_content_options ),
					mascot_core_charitab_get_cat_filter_arraylist( 3, $group_content_options ),

					
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Title", 'mascot-core' ),
						"param_name"	=> "show_title",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'admin_label'   => true,
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Description", 'mascot-core' ),
						"param_name"	=> "show_description",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'admin_label'   => true,
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Featured Image", 'mascot-core' ),
						"param_name"	=> "show_featured_image",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'admin_label'   => true,
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Featured Image Size", 'mascot-core' ),
						"param_name"	=> "featured_image_size",
						'description'   => '',
						'value'			=> mascot_core_charitab_get_available_image_sizes_for_vc(),
						'std'			=> 'post-thumbnail',
						'admin_label'   => true,
						'dependency'	=> array('element' => 'show_featured_image', 'value' => 'true'),
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'checkbox',
						"heading"		=> esc_html__( "Show Post Meta", 'mascot-core' ),
						"param_name"	=> "show_post_meta",
						'description'   => '',
						'std'			=> 'true',
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'checkbox',
						"heading"		=> esc_html__( "Choose Post Meta", 'mascot-core' ),
						"param_name"	=> "post_meta_options",
						"description"	=> esc_html__( 'Enable/Disabling this option will show/hide each Post Meta.', 'mascot-core' ),
						'value'			=> $post_meta_array,
						'std'			=> 'show-post-by-author,show-post-date',
						'save_always'   => true,
						'dependency'	=> array('element' => 'show_post_meta', 'value' => 'true'),
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Following Post Meta Beside Read More Button", 'mascot-core' ),
						"param_name"	=> "style_classic_show_post_meta_beside_read_more_btn",
						"description"	=> esc_html__( 'Choose one which you want to show beside read more button. You must select it from "Show Post Meta" checkbox.', 'mascot-core' ),
						'value'			=> $post_meta_array,
						'std'			=> 'show-post-by-author',
						'save_always'   => true,
						'dependency'	=> array('element' => 'design_style', 'value' => 'blog-style3-classic'),
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Following Post Meta Over Featured Thumbnail", 'mascot-core' ),
						"param_name"	=> "style_modern_show_post_meta_beside_read_more_btn",
						"description"	=> esc_html__( 'Choose one which you want to show over featured image. You must select it from "Show Post Meta" checkbox.', 'mascot-core' ),
						'value'			=> $post_meta_array,
						'std'			=> 'show-post-by-author',
						'save_always'   => true,
						'dependency'	=> array('element' => 'design_style', 'value' => array('blog-style4-modern', 'blog-style6-current-theme')),
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Following Post Meta Beside Read More Button", 'mascot-core' ),
						"param_name"	=> "style_horizontal_show_post_meta_beside_read_more_btn",
						"description"	=> esc_html__( 'Choose one which you want to show beside read more button. You must select it from "Show Post Meta" checkbox.', 'mascot-core' ),
						'value'			=> $post_meta_array,
						'std'			=> 'show-post-by-author',
						'save_always'   => true,
						'dependency'	=> array('element' => 'design_style', 'value' => 'blog-style5-horizontal'),
						'group'			=> $group_content_options
					),




					
					//Button
					mascot_core_charitab_get_viewdetails_button_arraylist( 1, $group_button_options ),
					mascot_core_charitab_get_viewdetails_button_arraylist( 2, $group_button_options ),

					//Button options
					mascot_core_charitab_get_button_arraylist( 1, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 2, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 3, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 4, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 5, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 6, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 7, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 8, $group_button_options ),
					mascot_core_charitab_get_button_arraylist( 9, $group_button_options ),

					//Loadmore Button options
					mascot_core_charitab_get_viewdetails_button_arraylist( 1, $group_loadmore_button_options,  esc_html__( "Load More", 'mascot-core' ), 'loadmore_', 'false' ),
					mascot_core_charitab_get_viewdetails_button_arraylist( 2, $group_loadmore_button_options,  esc_html__( "Load More", 'mascot-core' ), 'loadmore_', 'false' ),
					$array = array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Loading Text", 'mascot-core' ),
						"param_name"	=> "loadmore_button_loading_text",
						'std'			=> esc_html__( "Loading...", 'mascot-core' ),
						'save_always'   => true,
						'group'			=> $group_loadmore_button_options
					),
					mascot_core_charitab_get_button_arraylist( 1, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 2, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 3, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 4, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 5, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 6, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 7, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 8, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 9, $group_loadmore_button_options, 'loadmore_' ),

					

					mascot_core_charitab_vc_add_css_editor(),


				)
			);
			vc_map( $vc_map );

			//Modify vc_map from themes
			if( function_exists('mascot_core_charitab_sc_blog_vc_map_modifier') ) {
				mascot_core_charitab_sc_blog_vc_map_modifier( $this->shortcode_base );
			}
		}
	}

	/**
	 * Renders shortcodes HTML
	 */
	public function render( $attr, $content = null ) {

		//Render Shortcode from themes
		if( function_exists('mascot_core_charitab_sc_blog_render') && function_exists('vc_map') ) {
			return mascot_core_charitab_sc_blog_render( $attr, $content );
		}
		
	}
}