<?php
namespace MASCOTCORECHARITAB\Shortcodes\Blockquote;

use MASCOTCORECHARITAB\Shortcodes\Lib;

/**
 * class SC_Blockquote
 * @package MASCOTCORECHARITAB\Shortcodes\Blockquote;
 */
class SC_Blockquote implements Lib\Mascot_Core_Charitab_Interface_Shortcodes {
	
	/**
	 * @var shortcode_base
	 */
	private $shortcode_base;

	/**
	 * construct
	 */
	public function __construct() {
		$this->shortcode_base = 'tm_blockquote';
		add_action('init', array($this, 'MapShortCodeVC'), 998);
	}

	/**
	 * Returns shortcode_base for shortcode
	 */
	public function getShortCodeBase() {
		return $this->shortcode_base;
	}

	/**
	 * Maps shortcode to Visual Composer
	 */
	public function MapShortCodeVC() {
		$text_options = esc_html__( 'Text Options', 'mascot-core' );
		$footer_cite_options = esc_html__( 'Footer Cite Options', 'mascot-core' );

		if(function_exists('vc_map')) {
			$vc_map = array(
				'name'		=> esc_html__( 'Blockquote', 'mascot-core' ),
				'base'		=>$this->shortcode_base,
				'category'	=> 'by TM',
				'icon'		=> 'mascot-vc-icons vc-icon-blockquote',
				'allowed_container_element' => 'vc_row',
				'params'	=>array(
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Custom CSS class", 'mascot-core' ),
						"param_name"	=> "custom_css_class",
						"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
					),

					
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Design Style", 'mascot-core' ),
						"param_name"	=> "design_style",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Style 1', 'mascot-core' )	=> 'blockquote-style1',
							esc_html__( 'Style 2', 'mascot-core' )	=> 'blockquote-style2',
							esc_html__( 'Style 3', 'mascot-core' )	=> 'blockquote-style3',
							esc_html__( 'Style 4', 'mascot-core' )	=> 'blockquote-style4',
							esc_html__( 'Style 5', 'mascot-core' )	=> 'blockquote-style5',
							esc_html__( 'Style 6', 'mascot-core' )	=> 'blockquote-style6',
							esc_html__( 'Style 7', 'mascot-core' )	=> 'blockquote-style7',
							esc_html__( 'Style 8', 'mascot-core' )	=> 'blockquote-style8',
						),
						'admin_label'   => true,
						'save_always'   => true,
					),

					array(
						'type'			=> 'textarea',
						"heading"		=> esc_html__( "Text", 'mascot-core' ),
						"param_name"	=> "text",
						'admin_label'   => true,
					),

					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Footer Text (cite)", 'mascot-core' ),
						"param_name"	=> "footer_cite",
						'admin_label'   => true,
					),




					//Text Options
					array(
						'type'			=> 'colorpicker',
						"heading"		=> esc_html__( "Text Color", 'mascot-core' ),
						"param_name"	=> "text_text_color",
						"value"		 => '',
						'group'			=> $text_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Font Size", 'mascot-core' ),
						"param_name"	=> "text_font_size",
						"description"	=> "",
						'group'			=> $text_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Line Height", 'mascot-core' ),
						"param_name"	=> "text_line_height",
						"description"	=> "",
						'group'			=> $text_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Letter Spacing", 'mascot-core' ),
						"param_name"	=> "text_letter_spacing",
						"description"	=> "",
						'group'			=> $text_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Font Style", 'mascot-core' ),
						"param_name"	=> "text_font_style",
						"description"	=> "",
						'value'			=> mascot_core_charitab_vc_font_style_list(),
						'group'			=> $text_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Font Weight", 'mascot-core' ),
						"param_name"	=> "text_font_weight",
						"description"	=> "",
						'value'			=> mascot_core_charitab_vc_font_weight_list(),
						'group'			=> $text_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Text Transform", 'mascot-core' ),
						"param_name"	=> "text_text_transform",
						"description"	=> "",
						'value'			=> mascot_core_charitab_vc_text_transform_list(),
						'group'			=> $text_options
					),




					//Text Options
					array(
						'type'			=> 'colorpicker',
						"heading"		=> esc_html__( "Text Color", 'mascot-core' ),
						"param_name"	=> "footer_cite_text_color",
						"value"		 => '',
						'group'			=> $footer_cite_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Font Size", 'mascot-core' ),
						"param_name"	=> "footer_cite_font_size",
						"description"	=> "",
						'group'			=> $footer_cite_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Line Height", 'mascot-core' ),
						"param_name"	=> "footer_cite_line_height",
						"description"	=> "",
						'group'			=> $footer_cite_options
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Letter Spacing", 'mascot-core' ),
						"param_name"	=> "footer_cite_letter_spacing",
						"description"	=> "",
						'group'			=> $footer_cite_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Font Style", 'mascot-core' ),
						"param_name"	=> "footer_cite_font_style",
						"description"	=> "",
						'value'			=> mascot_core_charitab_vc_font_style_list(),
						'group'			=> $footer_cite_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Font Weight", 'mascot-core' ),
						"param_name"	=> "footer_cite_font_weight",
						"description"	=> "",
						'value'			=> mascot_core_charitab_vc_font_weight_list(),
						'group'			=> $footer_cite_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Text Transform", 'mascot-core' ),
						"param_name"	=> "footer_cite_text_transform",
						"description"	=> "",
						'value'			=> mascot_core_charitab_vc_text_transform_list(),
						'group'			=> $footer_cite_options
					),

					array(
						'type'			=> 'checkbox',
						"heading"		=> esc_html__( "Border Left Theme Colored", 'mascot-core' ),
						"param_name"	=> "border_left_theme_colored",
						'value'			=> array( esc_html__('Make Border Left Theme Colored?', 'mascot-core') => 'no' ),
					),
					array(
						'type'			=> 'checkbox',
						"heading"		=> esc_html__( "Quote Icon Theme Colored", 'mascot-core' ),
						"param_name"	=> "quote_icon_theme_colored",
						'value'			=> array( esc_html__('Make Quote Icon Theme Colored?', 'mascot-core') => 'no' ),
					),
					array(
						'type'			=> 'checkbox',
						"heading"		=> esc_html__( "Footer Cite Theme Colored", 'mascot-core' ),
						"param_name"	=> "footer_cite_theme_colored",
						'value'			=> array( esc_html__('Make Footer Cite Theme Colored?', 'mascot-core') => 'no' ),
					),


					mascot_core_charitab_vc_add_css_editor(),

				)
			);
			vc_map( $vc_map );

			//Modify vc_map from themes
			if( function_exists('mascot_core_charitab_sc_blockquote_vc_map_modifier') ) {
				mascot_core_charitab_sc_blockquote_vc_map_modifier( $this->shortcode_base );
			}
		}
	}

	/**
	 * Renders shortcodes HTML
	 */
	public function render( $attr, $content = null ) {

		//Render Shortcode from themes
		if( function_exists('mascot_core_charitab_sc_blockquote_render') && function_exists('vc_map') ) {
			return mascot_core_charitab_sc_blockquote_render( $attr, $content );
		}
		
	}
}