<?php
namespace MASCOTCORECHARITAB\CPT\Testimonials\Shortcodes;

use MASCOTCORECHARITAB\Lib;
use MASCOTCORECHARITAB\CPT\Testimonials\CPT_Testimonials;

/**
 * class SC_Testimonials
 * @package MASCOTCORECHARITAB\CPT\Testimonials\Shortcodes;
 */
class SC_Testimonials implements Lib\Mascot_Core_Charitab_Interface_PTShortcodes {
	
	/**
	 * @var string
	 */
	private $base;

	/**
	 * construct
	 */
	public function __construct() {
		if ( class_exists( 'ReduxFramework' ) ) {
			if( ! mascot_core_charitab_get_redux_option( 'cpt-settings-testimonials-enable', true ) ) {
				return;
			}
		}
		$this->base = 'tmvc_testimonials';
		add_action('init', array($this, 'vcMap'), 998);
	}

	/**
	 * Returns base for shortcode
	 * @return string
	 */
	public function getBase() {
		return $this->base;
	}

	/**
	 * Maps shortcode to Visual Composer
	 *
	 * @see vc_map()
	 */
	public function vcMap() {
		if(function_exists('vc_map')) {
			$group_content_options = esc_html__( 'Content Options', 'mascot-core' );
			$group_carousel_options = esc_html__( 'Carousel Options', 'mascot-core' );
			$group_query_options = esc_html__( 'Query Options', 'mascot-core' );
			$group_loadmore_button_options = esc_html__( 'Loadmore Button', 'mascot-core' );
			$new_cpt_class = CPT_Testimonials::Instance();
			$categories_array = mascot_core_charitab_category_list_array_for_vc( $new_cpt_class->ptTaxKey );

			$orderby_parameters_list = mascot_core_charitab_orderby_parameters_list();


			$vc_map = array(
				'name'		=> esc_html__( 'Testimonials', 'mascot-core' ),
				'base'		=>$this->base,
				'category'	=> 'by TM',
				'description' => esc_html__( 'Testimonials Grid/Carousel', 'mascot-core' ),
				'icon'		=> 'mascot-vc-icons vc-icon-testimonials',
				'allowed_container_element' => 'vc_row',
				'params'	=>array(
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Custom CSS class", 'mascot-core' ),
						"param_name"	=> "custom_css_class",
						"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Display Type", 'mascot-core' ),
						"param_name"	=> "display_type",
						"description"	=> "",
						'value'			=> array(
							esc_html__( 'Grid', 'mascot-core' )				=> 'grid',
							esc_html__( 'Masonry', 'mascot-core' )			=> 'masonry',
							esc_html__( 'Carousel', 'mascot-core' )			=> 'carousel',
							esc_html__( 'Thumb Carousel', 'mascot-core' )	=> 'thumb-carousel'
						),
						'save_always'   => true,
						'admin_label'   => true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Design Style", 'mascot-core' ),
						"param_name"	=> "design_style",
						"description"	=> "",
						'value'			=> array(
							esc_html__( 'Style 1 - Simple and Default', 'mascot-core' )			=> 'testimonial-style1-simple',
							esc_html__( 'Style 2 - Everything Center Aligned', 'mascot-core' )	=> 'testimonial-style2-centered-aligned',
							esc_html__( 'Style 3 - Classic', 'mascot-core' )					=> 'testimonial-style3-classic',
							esc_html__( 'Style 4 - Modern', 'mascot-core' )						=> 'testimonial-style4-modern',
							esc_html__( 'Style 5 - Boxed', 'mascot-core' )						=> 'testimonial-style5-boxed',
							esc_html__( 'Style 6 - Boxed Flat', 'mascot-core' )					=> 'testimonial-style6-boxed-flat',
							esc_html__( 'Style 7 - Current Theme', 'mascot-core' )				=> 'testimonial-style7-current-theme',
						),
						'save_always'   => true,
						'admin_label'   => true,
						'dependency'	=> array('element' => 'display_type', 'value' => array('grid', 'masonry', 'carousel') ),
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Columns Layout", 'mascot-core' ),
						"param_name"	=> "columns",
						"description"	=> esc_html__( 'Define Columns Layout for Grid/Carousel.', 'mascot-core' ),
						'value'			=> array(
							'1'  =>  '1',
							'2'  =>  '2',
							'3'  =>  '3',
							'4'  =>  '4',
							'5'  =>  '5',
							'6'  =>  '6',
						),
						'std'			=> 3,
						'admin_label'   => true,
						'dependency'	=> array('element' => 'display_type', 'value' => array('grid', 'masonry', 'carousel') ),
					),
					array(
						'type'			=> 'attach_image',
						"heading"		=> esc_html__( "Custom Quote Icon", 'mascot-core' ),
						"param_name"	=> "custom_quote_icon",
						"description"	=> esc_html__( 'Upload the custom quote icon.', 'mascot-core' ),
					),
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Custom Quote Icon Opacity", 'mascot-core' ),
						"param_name"	=> "custom_quote_icon_opacity",
						"description"	=> esc_html__( 'Set opacity to the custom quote icon. Opacity value must be between 0 to 1', 'mascot-core' ),
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Custom Quote Icon Alignment", 'mascot-core' ),
						"param_name"	=> "custom_quote_icon_alignment",
						"description"	=> esc_html__( 'Define custom quote icon alignment.', 'mascot-core' ),
						'value'			=> array(
							esc_html__( 'Left', 'mascot-core' )		=> 'custom-quote-icon-left',
							esc_html__( 'Center', 'mascot-core' )	=> 'custom-quote-icon-center',
							esc_html__( 'Right', 'mascot-core' )	=> 'custom-quote-icon-right'
						),
					),



					//Carousel Options
					mascot_core_charitab_get_owl_carousel_arraylist( 1, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel', 'thumb-carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 2, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel', 'thumb-carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 3, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel', 'thumb-carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 4, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel', 'thumb-carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 5, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel', 'thumb-carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 6, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel', 'thumb-carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 7, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel', 'thumb-carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 8, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel', 'thumb-carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 9, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel', 'thumb-carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 10, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel', 'thumb-carousel' ) ) ),


					//Query Options
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Number of Items to Query from Database", 'mascot-core' ),
						"param_name"	=> "total_items",
						"description"	=> esc_html__( 'How many items do you wish to show? Put -1 to show all. Default 3', 'mascot-core' ),
						'value'			=> 3,
						'admin_label'	=> true,
						'group'			=> $group_query_options
					),
					array(
						'type'			=> 'checkbox',
						"heading"		=> esc_html__( "Category", 'mascot-core' ),
						"param_name"	=> "selected_category",
						"description"	=> esc_html__( 'Choose a category to pull testimonials from.', 'mascot-core' ),
						'value'			=> $categories_array,
						'group'			=> $group_query_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Order By", 'mascot-core' ),
						"param_name"	=> "order_by",
						"description"	=> esc_html__( 'Select how to sort retrieved posts.', 'mascot-core' ),
						'value'			=> $orderby_parameters_list,
						'std'			=> $orderby_parameters_list[ 'Date' ],
						'group'			=> $group_query_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Order", 'mascot-core' ),
						"param_name"	=> "order",
						"description"	=> esc_html__( 'Descending or Ascending order.', 'mascot-core' ),
						'value'			=> array(
							esc_html__( 'Descending', 'mascot-core' )	=> 'DESC',
							esc_html__( 'Ascending', 'mascot-core' )	=> 'ASC',
						),
						'group'			=> $group_query_options
					),



					//Content Options
					
					//Category Filter
					mascot_core_charitab_get_cat_filter_arraylist( 1, $group_content_options, array('element' => 'display_type', 'value' => array('grid', 'masonry', 'carousel') ) ),
					mascot_core_charitab_get_cat_filter_arraylist( 2, $group_content_options ),
					mascot_core_charitab_get_cat_filter_arraylist( 3, $group_content_options ),
					
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Thumb", 'mascot-core' ),
						"param_name"	=> "show_thumb",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'admin_label'   => true,
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Thumbnail Image Size", 'mascot-core' ),
						"param_name"	=> "feature_thumb_image_size",
						'description'   => '',
						'value'			=> mascot_core_charitab_get_available_image_sizes_for_vc(),
						'std'			=> 'post-thumbnail',
						'save_always'   => true,
						'admin_label'   => true,
						'dependency'	=> array('element' => 'show_thumb', 'value' => 'true'),
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Testimonial Text", 'mascot-core' ),
						"param_name"	=> "show_testimonial_text",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'admin_label'   => true,
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Testimonial Title", 'mascot-core' ),
						"param_name"	=> "show_testimonial_title",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'admin_label'   => true,
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Author Name", 'mascot-core' ),
						"param_name"	=> "show_author_name",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'admin_label'   => true,
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Rating", 'mascot-core' ),
						"param_name"	=> "show_rating",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'admin_label'   => true,
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Default Quote Icon", 'mascot-core' ),
						"param_name"	=> "show_quote_icon",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'admin_label'   => true,
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Job Position", 'mascot-core' ),
						"param_name"	=> "show_author_job_position",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'admin_label'   => true,
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Company", 'mascot-core' ),
						"param_name"	=> "show_author_company",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'admin_label'   => true,
						'group'			=> $group_content_options
					),
					

					//Loadmore Button options
					mascot_core_charitab_get_viewdetails_button_arraylist( 1, $group_loadmore_button_options,  esc_html__( "Load More", 'mascot-core' ), 'loadmore_', 'false' ),
					mascot_core_charitab_get_viewdetails_button_arraylist( 2, $group_loadmore_button_options,  esc_html__( "Load More", 'mascot-core' ), 'loadmore_', 'false' ),
					$array = array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Loading Text", 'mascot-core' ),
						"param_name"	=> "loadmore_button_loading_text",
						'std'			=> esc_html__( "Loading...", 'mascot-core' ),
						'save_always'   => true,
						'group'			=> $group_loadmore_button_options
					),
					mascot_core_charitab_get_button_arraylist( 1, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 2, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 3, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 4, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 5, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 6, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 7, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 8, $group_loadmore_button_options, 'loadmore_' ),
					mascot_core_charitab_get_button_arraylist( 9, $group_loadmore_button_options, 'loadmore_' ),

				)
			);
			vc_map( $vc_map );

			//Modify vc_map from themes
			if( function_exists('mascot_core_charitab_cpt_sc_testimonials_vc_map_modifier') ) {
				mascot_core_charitab_cpt_sc_testimonials_vc_map_modifier( $this->base );
			}
		}
	}

	/**
	 * Renders shortcodes HTML
	 *
	 * @param $attr array of shortcode params
	 * @param $content string shortcode content
	 * @return string
	 */
	public function render( $attr, $content = null ) {
		if ( class_exists( 'ReduxFramework' ) ) {
			if( ! mascot_core_charitab_get_redux_option( 'cpt-settings-testimonials-enable', true ) ) {
				return;
			}
		}

		//Render Shortcode from themes
		if( function_exists('mascot_core_charitab_cpt_sc_testimonials_render') && function_exists('vc_map') ) {
			return mascot_core_charitab_cpt_sc_testimonials_render( $attr, $content, CPT_Testimonials::Instance() );
		}
		
	}
}