<?php
if(function_exists('vc_map')) {
	add_action( 'init', 'mascot_core_charitab_reg_shortcodes_pet', 998 );
}
function mascot_core_charitab_reg_shortcodes_pet() {


	vc_map( array(
		'name'     => esc_html__( 'Pet Title/Name', 'mascot-core' ),
		'base'     => 'tmvc_pet_name',
		'description' => esc_html__( 'Pet', 'mascot-core' ),
		'category' => esc_html__( 'by TM Partials', 'mascot-core' ),
		'icon'	   => 'mascot-vc-icons vc-icon-tm-parts',
		'params'   => array(
			mascot_core_charitab_vc_add_css_editor(),
		)
	) );
	class WPBakeryShortCode_tmvc_pet_name extends WPBakeryShortCode {
	}


	vc_map( array(
		'name'     => esc_html__( 'Pet Thumb', 'mascot-core' ),
		'base'     => 'tmvc_pet_thumb',
		'description' => esc_html__( 'Pet', 'mascot-core' ),
		'category' => esc_html__( 'by TM Partials', 'mascot-core' ),
		'icon'	   => 'mascot-vc-icons vc-icon-tm-parts',
		'params'   => array(
			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "Thumbnail Image Size", 'mascot-core' ),
				"param_name"	=> "thumb_image_size",
				'description'   => '',
				'value'			=> mascot_core_charitab_get_available_image_sizes_for_vc(),
				'std'			=> 'charitab_mascot_square',
				'admin_label'   => true,
			),
			mascot_core_charitab_vc_add_css_editor(),
		)
	) );
	class WPBakeryShortCode_tmvc_pet_thumb extends WPBakeryShortCode {
	}


	vc_map( array(
		'name'     => esc_html__( 'Pet Speciality', 'mascot-core' ),
		'base'     => 'tmvc_pet_speciality',
		'description' => esc_html__( 'Pet', 'mascot-core' ),
		'category' => esc_html__( 'by TM Partials', 'mascot-core' ),
		'icon'	   => 'mascot-vc-icons vc-icon-tm-parts',
		'params'   => array(
			mascot_core_charitab_vc_add_css_editor(),
		)
	) );
	class WPBakeryShortCode_tmvc_pet_speciality extends WPBakeryShortCode {
	}


	vc_map( array(
		'name'     => esc_html__( 'Pet Short Bio', 'mascot-core' ),
		'base'     => 'tmvc_pet_short_bio',
		'description' => esc_html__( 'Pet', 'mascot-core' ),
		'category' => esc_html__( 'by TM Partials', 'mascot-core' ),
		'icon'	   => 'mascot-vc-icons vc-icon-tm-parts',
		'params'   => array(
			mascot_core_charitab_vc_add_css_editor(),
		)
	) );
	class WPBakeryShortCode_tmvc_pet_short_bio extends WPBakeryShortCode {
	}


	//pet gallery shortcode
	$group_content_options = esc_html__( 'Content Options', 'mascot-core' );
	$group_carousel_options = esc_html__( 'Carousel Options', 'mascot-core' );
	$group_design_options = esc_html__( 'Design Options', 'mascot-core' );
	vc_map( array(
		'name'     => esc_html__( 'Pet Gallery', 'mascot-core' ),
		'base'     => 'tmvc_pet_gallery',
		'description' => esc_html__( 'Pet', 'mascot-core' ),
		'category' => esc_html__( 'by TM Partials', 'mascot-core' ),
		'icon'	   => 'mascot-vc-icons vc-icon-tm-parts',
		'params'   => array(
			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "Gallery Type", 'mascot-core' ),
				"param_name"	=> "gallery_type",
				"description"	=> "",
				'value'			=> array(
					esc_html__( 'Grid', 'mascot-core' )		=> 'grid',
					esc_html__( 'Carousel', 'mascot-core' )	=> 'carousel'
				),
				'save_always'   => true,
				'admin_label'   => true,
			),
			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "Columns Layout", 'mascot-core' ),
				"param_name"	=> "columns",
				"description"	=> esc_html__( 'Define Columns Layout for Grid/Carousel.', 'mascot-core' ),
				'value'			=> array(
					'1'  =>  '1',
					'2'  =>  '2',
					'3'  =>  '3',
					'4'  =>  '4',
					'5'  =>  '5',
					'6'  =>  '6',
				),
				'std'			=> 3,
				'save_always'   => true,
				'admin_label'   => true,
			),
			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "Gutter", 'mascot-core' ),
				"param_name"	=> "gutter",
				"description"	=> esc_html__( 'Define Gutter Size for Grid.', 'mascot-core' ),
				'value'			=> mascot_core_charitab_portfolio_gutter_list(),
				'save_always'   => true,
				'admin_label'   => true,
				'dependency'	=> array('element' => 'gallery_type', 'value' => array('grid', 'masonry')),
			),
			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "Featured Image Size", 'mascot-core' ),
				"param_name"	=> "featured_image_size",
				'description'   => '',
				'value'			=> mascot_core_charitab_get_available_image_sizes_for_vc(),
				'std'			=> 'post-thumbnail',
				'save_always'   => true,
				'admin_label'   => true,
				'dependency'	=> array('element' => 'show_featured_image', 'value' => 'true'),
			),
			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "Show Title", 'mascot-core' ),
				"param_name"	=> "show_gallery_title",
				'description'   => '',
				'value'			=> array(
					esc_html__( 'Yes', 'mascot-core' )	=> 'true',
					esc_html__( 'No', 'mascot-core' )	=> 'false'
				),
				'save_always'   => true,
				'admin_label'   => true,
			),
			array(
				'type'			=> 'dropdown',
				"heading"		=> esc_html__( "Lightbox Type", 'mascot-core' ),
				"param_name"	=> "gallery_lightbox_type",
				'description'   => '',
				'value'			=> array(
					esc_html__( 'Pretty Photo ', 'mascot-core' )	=> 'pretty-photo',
					esc_html__( 'Nivo Lightbox', 'mascot-core' )	=> 'nivo-lightbox'
				),
				'save_always'   => true,
				'admin_label'   => true,
			),



			//Carousel Options
			mascot_core_charitab_get_owl_carousel_arraylist( 1, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
			mascot_core_charitab_get_owl_carousel_arraylist( 2, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
			mascot_core_charitab_get_owl_carousel_arraylist( 3, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
			mascot_core_charitab_get_owl_carousel_arraylist( 4, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
			mascot_core_charitab_get_owl_carousel_arraylist( 5, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
			mascot_core_charitab_get_owl_carousel_arraylist( 6, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
			mascot_core_charitab_get_owl_carousel_arraylist( 7, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
			mascot_core_charitab_get_owl_carousel_arraylist( 8, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
			mascot_core_charitab_get_owl_carousel_arraylist( 9, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
			mascot_core_charitab_get_owl_carousel_arraylist( 10, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),


			mascot_core_charitab_vc_add_css_editor(),
		)
	) );
	class WPBakeryShortCode_tmvc_pet_gallery extends WPBakeryShortCode {
	}
}