<?php
namespace MASCOTCORECHARITAB\CPT\Clients\Shortcodes;

use MASCOTCORECHARITAB\Lib;
use MASCOTCORECHARITAB\CPT\Clients\CPT_Clients;

/**
 * class SC_Clients
 * @package MASCOTCORECHARITAB\CPT\Clients\Shortcodes;
 */
class SC_Clients implements Lib\Mascot_Core_Charitab_Interface_PTShortcodes {
	
	/**
	 * @var string
	 */
	private $base;

	/**
	 * construct
	 */
	public function __construct() {
		if ( class_exists( 'ReduxFramework' ) ) {
			if( ! mascot_core_charitab_get_redux_option( 'cpt-settings-clients-enable', true ) ) {
				return;
			}
		}
		$this->base = 'tmvc_clients';
		add_action('init', array($this, 'vcMap'), 998);
	}

	/**
	 * Returns base for shortcode
	 * @return string
	 */
	public function getBase() {
		return $this->base;
	}

	/**
	 * Maps shortcode to Visual Composer
	 *
	 * @see vc_map()
	 */
	public function vcMap() {
		if(function_exists('vc_map')) {
			$group_content_options = esc_html__( 'Content Options', 'mascot-core' );
			$group_carousel_options = esc_html__( 'Carousel Options', 'mascot-core' );
			$group_query_options = esc_html__( 'Query Options', 'mascot-core' );
			$new_cpt_class = CPT_Clients::Instance();
			$categories_array = mascot_core_charitab_category_list_array_for_vc( $new_cpt_class->ptTaxKey );

			$orderby_parameters_list = mascot_core_charitab_orderby_parameters_list();


			$vc_map = array(
				'name'		=> esc_html__( 'Clients', 'mascot-core' ),
				'base'		=>$this->base,
				'category'	=> 'by TM',
				'description' => esc_html__( 'Clients Grid/Carousel', 'mascot-core' ),
				'icon'		=> 'mascot-vc-icons vc-icon-clients',
				'allowed_container_element' => 'vc_row',
				'params'	=>array(
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Custom CSS class", 'mascot-core' ),
						"param_name"	=> "custom_css_class",
						"description"	=> esc_html__( 'To style particular content element.', 'mascot-core' ),
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Display Type", 'mascot-core' ),
						"param_name"	=> "display_type",
						"description"	=> "",
						'value'			=> array(
							esc_html__( 'Grid', 'mascot-core' )		=> 'grid',
							esc_html__( 'Carousel', 'mascot-core' )	=> 'carousel'
						),
						'save_always'   => true,
						'admin_label'   => true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Number of visible items", 'mascot-core' ),
						"param_name"	=> "columns",
						"description"	=> esc_html__( 'Select number of items for visible.', 'mascot-core' ),
						'value'			=> array(
							'2'  =>  '2',
							'3'  =>  '3',
							'4'  =>  '4',
							'5'  =>  '5',
							'6'  =>  '6',
							'7'  =>  '7',
							'8'  =>  '8',
							'9'  =>  '9',
						),
						'std'			=> 6,
						'dependency'	=> array('element' => 'display_type', 'value' => array('carousel') ),
						'admin_label'   => true,
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Columns Layout", 'mascot-core' ),
						"param_name"	=> "columns_grid",
						"description"	=> esc_html__( 'Define Columns Layout for Grid/Carousel.', 'mascot-core' ),
						'value'			=> array(
							'1'  =>  '1',
							'2'  =>  '2',
							'3'  =>  '3',
							'4'  =>  '4',
							'6'  =>  '6'
						),
						'std'			=> 6,
						'admin_label'   => true,
						'dependency'	=> array('element' => 'display_type', 'value' => array('grid') ),
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Hover Animation Type", 'mascot-core' ),
						"param_name"	=> "hover_animation_type",
						"description"	=> "",
						'value'			=> array(
							esc_html__( 'No Effect', 'mascot-core' )		=> 'clients-animation-no-effect',
							esc_html__( 'Grayscale Effect', 'mascot-core' )	=> 'clients-animation-grayscale',
							esc_html__( 'Opacity Effect', 'mascot-core' )	=> 'clients-animation-opacity',
							esc_html__( 'Blur Effect', 'mascot-core' )		=> 'clients-animation-blur',
							esc_html__( 'Zoom Effect', 'mascot-core' )		=> 'clients-animation-zoom',
							esc_html__( 'Contrast Effect', 'mascot-core' )	=> 'clients-animation-contrast',
							esc_html__( 'Invert Effect', 'mascot-core' )	=> 'clients-animation-invert',
						),
						'save_always'   => true,
						'admin_label'   => true,
					),



					//Carousel Options
					mascot_core_charitab_get_owl_carousel_arraylist( 1, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 2, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 3, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 4, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 5, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 6, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 7, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 8, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 9, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),
					mascot_core_charitab_get_owl_carousel_arraylist( 10, $group_carousel_options, '', array('element' => 'display_type', 'value' => array( 'carousel' ) ) ),


					//Query Options
					array(
						'type'			=> 'textfield',
						"heading"		=> esc_html__( "Number of Items to Query from Database", 'mascot-core' ),
						"param_name"	=> "total_items",
						"description"	=> esc_html__( 'How many items do you wish to show? Put -1 to show all. Default 3', 'mascot-core' ),
						'value'			=> 3,
						'admin_label'	=> true,
						'group'			=> $group_query_options
					),
					array(
						'type'			=> 'checkbox',
						"heading"		=> esc_html__( "Category", 'mascot-core' ),
						"param_name"	=> "selected_category",
						"description"	=> esc_html__( 'Choose a category to pull clients from.', 'mascot-core' ),
						'value'			=> $categories_array,
						'group'			=> $group_query_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Order By", 'mascot-core' ),
						"param_name"	=> "order_by",
						"description"	=> esc_html__( 'Select how to sort retrieved posts.', 'mascot-core' ),
						'value'			=> $orderby_parameters_list,
						'std'			=> $orderby_parameters_list[ 'Date' ],
						'group'			=> $group_query_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Order", 'mascot-core' ),
						"param_name"	=> "order",
						"description"	=> esc_html__( 'Descending or Ascending order.', 'mascot-core' ),
						'value'			=> array(
							esc_html__( 'Descending', 'mascot-core' )	=> 'DESC',
							esc_html__( 'Ascending', 'mascot-core' )	=> 'ASC',
						),
						'group'			=> $group_query_options
					),



					//Content Options
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Client Name", 'mascot-core' ),
						"param_name"	=> "show_client_name",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'No', 'mascot-core' )	=> 'false',
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
						),
						'std'			=> 'false',
						'admin_label'   => true,
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Client description", 'mascot-core' ),
						"param_name"	=> "show_client_description",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'No', 'mascot-core' )	=> 'false',
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
						),
						'std'			=> 'false',
						'admin_label'   => true,
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Show Client Logo", 'mascot-core' ),
						"param_name"	=> "show_client_logo",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'admin_label'   => true,
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Link Client Logo by Url", 'mascot-core' ),
						"param_name"	=> "link_client_url",
						'description'   => '',
						'value'			=> array(
							esc_html__( 'Yes', 'mascot-core' )	=> 'true',
							esc_html__( 'No', 'mascot-core' )	=> 'false'
						),
						'admin_label'   => true,
						'group'			=> $group_content_options
					),
					array(
						'type'			=> 'dropdown',
						"heading"		=> esc_html__( "Open links in", 'mascot-core' ),
						"param_name"	=> "open_links_in",
						'description'   => '',
						'value'			=> mascot_core_charitab_open_link_in(),
						'admin_label'   => true,
						'dependency'	=> array('element' => 'link_client_url', 'value' => 'true'),
						'group'			=> $group_content_options
					),

				)
			);
			vc_map( $vc_map );

			//Modify vc_map from themes
			if( function_exists('mascot_core_charitab_cpt_sc_clients_vc_map_modifier') ) {
				mascot_core_charitab_cpt_sc_clients_vc_map_modifier( $this->base );
			}
		}
	}

	/**
	 * Renders shortcodes HTML
	 *
	 * @param $attr array of shortcode params
	 * @param $content string shortcode content
	 * @return string
	 */
	public function render( $attr, $content = null ) {
		if ( class_exists( 'ReduxFramework' ) ) {
			if( ! mascot_core_charitab_get_redux_option( 'cpt-settings-clients-enable', true ) ) {
				return;
			}
		}

		//Render Shortcode from themes
		if( function_exists('mascot_core_charitab_cpt_sc_clients_render') && function_exists('vc_map') ) {
			return mascot_core_charitab_cpt_sc_clients_render( $attr, $content, CPT_Clients::Instance() );
		}
		
	}
}